/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BitbucketCICapabilities {
    private static final String RICH_BUILD_STATUS_CAPABILITY = "richBuildStatus";
    private static final String CANCELLED_BUILD_STATE_CAPABILITIES = "cancelledStatus";
    private final Set<String> ciCapabilities;

    @JsonCreator
    public BitbucketCICapabilities(@JsonProperty(value="buildStatus") Set<String> ciCapabilities) {
        this.ciCapabilities = Collections.unmodifiableSet(Objects.requireNonNull(ciCapabilities, "Build status capability missing."));
    }

    public Set<String> getCiCapabilities() {
        return this.ciCapabilities;
    }

    public boolean supportsCancelledBuildStates() {
        return this.ciCapabilities.contains(CANCELLED_BUILD_STATE_CAPABILITIES);
    }

    public boolean supportsRichBuildStatus() {
        return this.ciCapabilities.contains(RICH_BUILD_STATUS_CAPABILITY);
    }
}

