/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.link;

import com.atlassian.bitbucket.jenkins.internal.link.BitbucketLinkType;
import hudson.model.Action;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.jenkins.ui.icon.IconType;
import org.kohsuke.stapler.Stapler;

public class BitbucketExternalLink
implements Action,
IconSpec {
    private static final String ICON_CLASS_NAME = "icon-bitbucket-logo";
    private final BitbucketLinkType linkType;
    private final String url;

    public BitbucketExternalLink(String url, BitbucketLinkType linkType) {
        this.linkType = linkType;
        this.url = url;
    }

    @CheckForNull
    public String getDisplayName() {
        return this.linkType.getDisplayName();
    }

    public String getIconClassName() {
        return ICON_CLASS_NAME;
    }

    @CheckForNull
    public String getIconFileName() {
        JellyContext ctx = new JellyContext();
        ctx.setVariable("resURL", (Object)(Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH));
        return IconSet.icons.getIconByClassSpec((Object)"icon-bitbucket-logo icon-md").getQualifiedUrl(ctx);
    }

    @CheckForNull
    public String getUrlName() {
        return this.url;
    }

    static {
        IconSet.icons.addIcon(new Icon("icon-bitbucket-logo icon-md", "atlassian-bitbucket-server-integration/images/24x24/bitbucket.png", "width: 24px; height: 24px;", IconType.PLUGIN));
    }
}

