/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.deployments;

import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentStep;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironment;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironmentType;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.StringUtils;

public class DeploymentStepUtils {
    private static final Logger LOGGER = Logger.getLogger(DeploymentStepUtils.class.getName());

    public static String getOrGenerateEnvironmentKey() {
        return DeploymentStepUtils.getOrGenerateEnvironmentKey(null);
    }

    public static String getOrGenerateEnvironmentKey(@CheckForNull String environmentKey) {
        if (!StringUtils.isBlank((CharSequence)environmentKey)) {
            return environmentKey;
        }
        return UUID.randomUUID().toString();
    }

    @CheckForNull
    public static BitbucketDeploymentEnvironmentType normalizeEnvironmentType(@CheckForNull String environmentType) {
        if (StringUtils.isBlank((CharSequence)environmentType)) {
            return null;
        }
        return BitbucketDeploymentEnvironmentType.fromName(environmentType).orElseGet(() -> {
            LOGGER.fine(String.format("Invalid environment type '%s'.", environmentType));
            return null;
        });
    }

    public static BitbucketDeploymentEnvironment getEnvironment(DeploymentStep step, Run<?, ?> run, TaskListener listener) {
        BitbucketDeploymentEnvironmentType type = DeploymentStepUtils.normalizeEnvironmentType(step.getEnvironmentType());
        String name = DeploymentStepUtils.getOrGenerateEnvironmentName(step.getEnvironmentName(), type, run, listener);
        URI url = DeploymentStepUtils.getEnvironmentUri(step.getEnvironmentUrl(), listener);
        return new BitbucketDeploymentEnvironment(step.getEnvironmentKey(), name, type, url);
    }

    @CheckForNull
    private static URI getEnvironmentUri(@CheckForNull String environmentUrl, TaskListener listener) {
        if (StringUtils.isBlank((CharSequence)environmentUrl)) {
            return null;
        }
        try {
            return new URI(environmentUrl);
        }
        catch (URISyntaxException x) {
            listener.getLogger().println(String.format("Invalid environment URL '%s'.", environmentUrl));
            return null;
        }
    }

    private static String getOrGenerateEnvironmentName(@CheckForNull String environmentName, @CheckForNull BitbucketDeploymentEnvironmentType environmentType, Run<?, ?> run, TaskListener listener) {
        if (!StringUtils.isBlank((CharSequence)environmentName)) {
            return environmentName;
        }
        String generatedEnvironmentName = environmentType != null ? environmentType.getDisplayName() : run.getParent().getDisplayName();
        listener.getLogger().println(String.format("Using '%s' as the environment name since it was not correctly configured. Please configure an environment name.", generatedEnvironmentName));
        return generatedEnvironmentName;
    }
}

