/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.credentials;

import com.atlassian.bitbucket.jenkins.internal.config.BitbucketTokenCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.BitbucketCredentials;
import com.atlassian.bitbucket.jenkins.internal.credentials.CredentialUtils;
import com.atlassian.bitbucket.jenkins.internal.credentials.JenkinsToBitbucketCredentials;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.model.Item;
import java.util.Base64;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import org.apache.commons.codec.Charsets;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

@Singleton
public class JenkinsToBitbucketCredentialsImpl
implements JenkinsToBitbucketCredentials {
    @Override
    public BitbucketCredentials toBitbucketCredentials(@Nullable String credentialId, @Nullable Item context) {
        return CredentialUtils.getCredentials(credentialId, context).map(this::toBitbucketCredentials).orElse(BitbucketCredentials.ANONYMOUS_CREDENTIALS);
    }

    @Override
    public BitbucketCredentials toBitbucketCredentials(@Nullable Credentials credentials) {
        if (credentials instanceof StringCredentials) {
            String bearerToken = ((StringCredentials)credentials).getSecret().getPlainText();
            return JenkinsToBitbucketCredentialsImpl.getBearerCredentials(bearerToken);
        }
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
            return JenkinsToBitbucketCredentialsImpl.getBasicCredentials(upc.getUsername(), upc.getPassword().getPlainText());
        }
        if (credentials instanceof BitbucketTokenCredentials) {
            String bearerToken = ((BitbucketTokenCredentials)credentials).getSecret().getPlainText();
            return JenkinsToBitbucketCredentialsImpl.getBearerCredentials(bearerToken);
        }
        return BitbucketCredentials.ANONYMOUS_CREDENTIALS;
    }

    public static BitbucketCredentials getBearerCredentials(String bearerToken) {
        return () -> "Bearer " + bearerToken;
    }

    private static BitbucketCredentials getBasicCredentials(String username, String password) {
        String authorization = username + ":" + password;
        return () -> "Basic " + Base64.getEncoder().encodeToString(authorization.getBytes(Charsets.UTF_8));
    }
}

