/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.credentials;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.model.Item;
import hudson.security.ACL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public final class CredentialUtils {
    private static final List<Class> CREDENTIAL_TYPES = Arrays.asList(StringCredentials.class, UsernamePasswordCredentials.class, BasicSSHUserPrivateKey.class);

    private CredentialUtils() {
        throw new UnsupportedOperationException(CredentialUtils.class.getName() + " should not be instantiated");
    }

    public static Optional<Credentials> getCredentials(@Nullable String credentialsId, @Nullable Item context) {
        return CREDENTIAL_TYPES.stream().map(type -> CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials((Class)type, (Item)context, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)StringUtils.trimToEmpty((String)credentialsId)))).filter(Objects::nonNull).findAny();
    }
}

