/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketTagClient;
import com.atlassian.bitbucket.jenkins.internal.client.RequestConfiguration;
import com.atlassian.bitbucket.jenkins.internal.client.paging.BitbucketPageStreamUtil;
import com.atlassian.bitbucket.jenkins.internal.client.paging.NextPageFetcher;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketPage;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketTag;
import com.fasterxml.jackson.core.type.TypeReference;
import hudson.model.TaskListener;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import okhttp3.HttpUrl;

public class BitbucketTagClientImpl
implements BitbucketTagClient {
    private static final int MAX_PAGES = Integer.getInteger("bitbucket.remote.tags.retrieval.max.pages", 5);
    private static final int PAGE_SIZE = Integer.getInteger("bitbucket.remote.tags.retrieve.page.size", 1000);
    private final BitbucketRequestExecutor bitbucketRequestExecutor;
    private final String projectKey;
    private final String repositorySlug;
    private final TaskListener taskListener;

    public BitbucketTagClientImpl(BitbucketRequestExecutor bitbucketRequestExecutor, String projectKey, String repositorySlug, TaskListener taskListener) {
        this.bitbucketRequestExecutor = bitbucketRequestExecutor;
        this.projectKey = projectKey;
        this.repositorySlug = repositorySlug;
        this.taskListener = taskListener;
    }

    @Override
    public Stream<BitbucketTag> getRemoteTags() {
        HttpUrl.Builder urlBuilder = this.bitbucketRequestExecutor.getCoreRestPath().newBuilder().addPathSegment("projects").addPathSegment(this.projectKey).addPathSegment("repos").addPathSegment(this.repositorySlug).addPathSegment("tags").addQueryParameter("limit", String.valueOf(PAGE_SIZE)).addQueryParameter("orderBy", "modification");
        HttpUrl url = urlBuilder.build();
        BitbucketPage<BitbucketTag> firstPage = this.bitbucketRequestExecutor.makeGetRequest(url, new TypeReference<BitbucketPage<BitbucketTag>>(){}, new RequestConfiguration[0]).getBody();
        return BitbucketPageStreamUtil.toStream(firstPage, new NextPageFetcherImpl(url, this.bitbucketRequestExecutor, MAX_PAGES, this.taskListener)).map(BitbucketPage::getValues).flatMap(Collection::stream);
    }

    static class NextPageFetcherImpl
    implements NextPageFetcher<BitbucketTag> {
        private final BitbucketRequestExecutor bitbucketRequestExecutor;
        private final AtomicInteger currentPage = new AtomicInteger();
        private final int maxPages;
        private final TaskListener taskListener;
        private final HttpUrl url;

        NextPageFetcherImpl(HttpUrl url, BitbucketRequestExecutor bitbucketRequestExecutor, int maxPages, TaskListener taskListener) {
            this.url = url;
            this.bitbucketRequestExecutor = bitbucketRequestExecutor;
            this.maxPages = maxPages;
            this.taskListener = taskListener;
        }

        @Override
        public BitbucketPage<BitbucketTag> next(BitbucketPage<BitbucketTag> previous) {
            if (this.currentPage.incrementAndGet() >= this.maxPages) {
                this.taskListener.getLogger().println("Max number of pages for tag retrieval reached.");
                BitbucketPage<BitbucketTag> lastPage = new BitbucketPage<BitbucketTag>();
                lastPage.setValues(Collections.emptyList());
                lastPage.setLastPage(true);
                return lastPage;
            }
            return this.bitbucketRequestExecutor.makeGetRequest(this.nextPageUrl(previous), new TypeReference<BitbucketPage<BitbucketTag>>(){}, new RequestConfiguration[0]).getBody();
        }

        private HttpUrl nextPageUrl(BitbucketPage<BitbucketTag> previous) {
            return this.url.newBuilder().addQueryParameter("start", String.valueOf(previous.getNextPageStart())).build();
        }
    }
}

