/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.rest;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.OAuthRequestUtils;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.AuthenticationFailedException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.OAuth1Authenticator;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.SecurityModeChecker;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.csrf.CrumbExclusion;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;

@Extension
public class OauthCrumbExclusion
extends CrumbExclusion {
    private static final Set<String> allowedParts = Set.of("/bitbucket/oauth/request-token", "/bbs-oauth/authorize/performSubmit", "/bitbucket/oauth/access-token");
    @Inject
    OAuthRequestUtils oAuthRequestUtils;
    @Inject
    private OAuth1Authenticator authenticator;
    @Inject
    private SecurityModeChecker securityChecker;

    public OauthCrumbExclusion() {
    }

    OauthCrumbExclusion(OAuth1Authenticator authenticator, SecurityModeChecker securityChecker, OAuthRequestUtils oAuthRequestUtils) {
        this.authenticator = authenticator;
        this.securityChecker = securityChecker;
        this.oAuthRequestUtils = oAuthRequestUtils;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(HttpServletRequest req, HttpServletResponse resp, FilterChain chain) throws IOException, ServletException {
        block13: {
            if (req.getPathInfo() == null) {
                return false;
            }
            if (req.getPathInfo().startsWith("/job") && req.getPathInfo().endsWith("/build")) {
                if (!this.securityChecker.isSecurityEnabled()) {
                    return false;
                }
                if (this.oAuthRequestUtils.isOAuthAccessAttempt(req) || this.oAuthRequestUtils.isOauthTokenRequest(req)) {
                    try {
                        User user = this.authenticator.authenticate(req, resp);
                        if (user == null) break block13;
                        try (ACLContext ignored = ACL.as((User)user);){
                            req.setAttribute("bbdc_authenticated", (Object)true);
                            List<String> buildPaths = this.getBuilds();
                            if (buildPaths.contains(req.getPathInfo())) {
                                chain.doFilter((ServletRequest)req, (ServletResponse)resp);
                                boolean throwable2 = true;
                                return throwable2;
                            }
                        }
                    }
                    catch (AuthenticationFailedException exception) {
                        String msg = String.format("User %s associated with the token %s not found in the system", exception.getUser(), exception.getTokenString());
                        OAuthServlet.handleException((HttpServletResponse)resp, (Exception)((Object)new OAuthProblemException(msg)), (String)OauthCrumbExclusion.getBaseUrl(req));
                    }
                }
            }
        }
        if (!allowedParts.contains(req.getPathInfo())) return false;
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        return true;
    }

    List<String> getBuilds() {
        return Jenkins.get().getAllItems(Job.class).stream().map(project -> "/" + project.getUrl() + "build").collect(Collectors.toList());
    }

    private static String getBaseUrl(HttpServletRequest request) {
        String scheme = request.getScheme() + "://";
        String serverName = request.getServerName();
        String serverPort = request.getServerPort() == 80 ? "" : ":" + request.getServerPort();
        String contextPath = request.getContextPath();
        return scheme + serverName + serverPort + contextPath;
    }
}

