/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.rest;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.OAuthConverter;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.exception.InvalidTokenException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenFactory;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.util.OAuthProblemUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Clock;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.server.OAuthServlet;

@Singleton
public class AccessTokenRestEndpoint {
    public static final String OAUTH_SESSION_HANDLE = "oauth_session_handle";
    public static final String OAUTH_EXPIRES_IN = "oauth_expires_in";
    public static final String OAUTH_AUTHORIZATION_EXPIRES_IN = "oauth_authorization_expires_in";
    public static final String ACCESS_TOKEN_PATH_END = "access-token";
    private static final Logger LOGGER = Logger.getLogger(AccessTokenRestEndpoint.class.getName());
    private OAuthValidator oAuthValidator;
    private ServiceProviderTokenFactory tokenFactory;
    private ServiceProviderTokenStore tokenStore;
    private Clock clock;

    @Inject
    public AccessTokenRestEndpoint(OAuthValidator oAuthValidator, ServiceProviderTokenFactory tokenFactory, ServiceProviderTokenStore tokenStore, Clock clock) {
        this.oAuthValidator = oAuthValidator;
        this.tokenFactory = tokenFactory;
        this.tokenStore = tokenStore;
        this.clock = clock;
    }

    public void handleAccessToken(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServiceProviderToken accessToken;
        try {
            ServiceProviderToken token;
            OAuthMessage requestMessage = OAuthServlet.getMessage((HttpServletRequest)request, null);
            requestMessage.requireParameters(new String[]{"oauth_token"});
            try {
                token = this.tokenStore.get(requestMessage.getToken()).orElseThrow(() -> new OAuthProblemException("token_rejected"));
            }
            catch (InvalidTokenException e) {
                throw new OAuthProblemException("token_rejected");
            }
            if (token.isRequestToken()) {
                this.checkRequestToken(requestMessage, token);
            } else {
                this.checkAccessToken(requestMessage, token);
            }
            try {
                this.oAuthValidator.validateMessage(requestMessage, OAuthConverter.createOAuthAccessor(token));
            }
            catch (OAuthProblemException ope) {
                OAuthProblemUtils.logOAuthProblem(requestMessage, ope, LOGGER);
                throw ope;
            }
            accessToken = this.tokenStore.put(this.tokenFactory.generateAccessToken(token));
            this.tokenStore.remove(token.getToken());
        }
        catch (Exception e) {
            OAuthServlet.handleException((HttpServletResponse)response, (Exception)e, (String)request.getRequestURL().toString(), (boolean)true);
            return;
        }
        response.setContentType("text/plain");
        ServletOutputStream out = response.getOutputStream();
        OAuth.formEncode((Iterable)OAuth.newList((String[])new String[]{"oauth_token", accessToken.getToken(), "oauth_token_secret", accessToken.getTokenSecret(), OAUTH_EXPIRES_IN, Long.toString(accessToken.getTimeToLive() / 1000L), OAUTH_SESSION_HANDLE, accessToken.getSession().getHandle(), OAUTH_AUTHORIZATION_EXPIRES_IN, Long.toString(accessToken.getSession().getTimeToLive() / 1000L)}), (OutputStream)out);
    }

    private void checkRequestToken(OAuthMessage requestMessage, ServiceProviderToken token) throws Exception {
        if (token.hasExpired(this.clock)) {
            throw new OAuthProblemException("token_expired");
        }
        if (token.getAuthorization() == ServiceProviderToken.Authorization.NONE) {
            throw new OAuthProblemException("permission_unknown");
        }
        if (token.getAuthorization() == ServiceProviderToken.Authorization.DENIED) {
            throw new OAuthProblemException("permission_denied");
        }
        if (!token.getConsumer().getKey().equals(requestMessage.getConsumerKey())) {
            throw new OAuthProblemException("token_rejected");
        }
        requestMessage.requireParameters(new String[]{"oauth_verifier"});
        if (!token.getVerifier().equals(requestMessage.getParameter("oauth_verifier"))) {
            throw new OAuthProblemException("token_rejected");
        }
    }

    private void checkAccessToken(OAuthMessage requestMessage, ServiceProviderToken token) throws Exception {
        if (token.getSession() == null) {
            throw new OAuthProblemException("token_rejected");
        }
        requestMessage.requireParameters(new String[]{OAUTH_SESSION_HANDLE});
        if (!token.getSession().getHandle().equals(requestMessage.getParameter(OAUTH_SESSION_HANDLE))) {
            throw new OAuthProblemException("token_rejected");
        }
        if (token.getSession().hasExpired(this.clock)) {
            throw new OAuthProblemException("permission_denied");
        }
    }
}

