/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer;

import java.net.URI;
import java.security.PublicKey;
import java.util.Objects;
import java.util.Optional;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Immutable
public final class Consumer {
    private final String key;
    private final String name;
    private final String description;
    private final SignatureMethod signatureMethod;
    private final PublicKey publicKey;
    private final URI callback;
    private final String consumerSecret;

    private Consumer(Builder builder) {
        this.key = builder.key;
        this.name = builder.name;
        this.signatureMethod = builder.signatureMethod;
        this.publicKey = builder.publicKey;
        this.description = builder.description;
        this.callback = builder.callback;
        this.consumerSecret = builder.consumerSecret;
    }

    public static Builder key(String key) {
        return new Builder(Objects.requireNonNull(key, "key"));
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    public Optional<PublicKey> getPublicKey() {
        return Optional.ofNullable(this.publicKey);
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<URI> getCallback() {
        return Optional.ofNullable(this.callback);
    }

    public Optional<String> getConsumerSecret() {
        return Optional.ofNullable(this.consumerSecret);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.key).append("name", (Object)this.name).append("description", (Object)this.description).append("callback", (Object)this.callback).append("signatureMethod", (Object)this.signatureMethod).append("publicKey", (Object)this.publicKey).toString();
    }

    public static final class Builder {
        private final String key;
        private String name;
        private SignatureMethod signatureMethod;
        private PublicKey publicKey;
        private String description = "";
        private URI callback;
        private String consumerSecret;

        public Builder(String key) {
            this.key = Objects.requireNonNull(key, "key");
        }

        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public Builder signatureMethod(SignatureMethod signatureMethod) {
            this.signatureMethod = Objects.requireNonNull(signatureMethod);
            return this;
        }

        public Builder publicKey(PublicKey publicKey) {
            this.signatureMethod = SignatureMethod.RSA_SHA1;
            this.publicKey = Objects.requireNonNull(publicKey);
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder callback(URI callback) {
            this.callback = callback;
            return this;
        }

        public Builder consumerSecret(String secret) {
            this.consumerSecret = secret;
            return this;
        }

        public Consumer build() {
            Objects.requireNonNull(this.name, "name");
            Objects.requireNonNull(this.signatureMethod, "signatureMethod");
            if (this.signatureMethod == SignatureMethod.RSA_SHA1) {
                Objects.requireNonNull(this.publicKey, "publicKey must be set when the signature method is RSA-SHA1");
            }
            return new Consumer(this);
        }
    }

    public static enum SignatureMethod {
        HMAC_SHA1,
        RSA_SHA1;

    }
}

