/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.OAuthConverter;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.OAuthRequestUtils;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.AuthenticationFailedException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.SecurityModeChecker;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.Consumer;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.ServiceProviderConsumerStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.exception.InvalidTokenException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.exception.NoSuchUserException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.util.OAuthProblemUtils;
import hudson.model.User;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Clock;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.server.OAuthServlet;
import org.apache.commons.lang3.StringUtils;

public class OAuth1Authenticator {
    private static final Logger log = Logger.getLogger(OAuth1Authenticator.class.getName());
    private final Clock clock;
    private final ServiceProviderConsumerStore consumerStore;
    private final OAuthRequestUtils oAuthRequestUtils;
    private final SecurityModeChecker securityChecker;
    private final ServiceProviderTokenStore tokenStore;
    private final OAuthValidator validator;

    @Inject
    public OAuth1Authenticator(ServiceProviderConsumerStore consumerStore, ServiceProviderTokenStore tokenStore, OAuthValidator validator, Clock clock, SecurityModeChecker securityChecker, OAuthRequestUtils oAuthRequestUtils) {
        this.consumerStore = consumerStore;
        this.tokenStore = tokenStore;
        this.validator = validator;
        this.clock = clock;
        this.securityChecker = securityChecker;
        this.oAuthRequestUtils = oAuthRequestUtils;
    }

    @CheckForNull
    public User authenticate(HttpServletRequest req, HttpServletResponse resp) throws AuthenticationFailedException {
        String user;
        if (!this.securityChecker.isSecurityEnabled()) {
            return null;
        }
        if (!this.isOauthRequest(req)) {
            return null;
        }
        OAuthMessage message = OAuthServlet.getMessage((HttpServletRequest)req, (String)this.getLogicalUri(req));
        String tokenStr = this.getTokenFromRequest(req, resp, message);
        if (tokenStr == null) {
            return null;
        }
        try {
            user = this.verifyToken(message, tokenStr);
        }
        catch (Exception ex) {
            throw new AuthenticationFailedException(null, tokenStr, message, ex);
        }
        try {
            return this.getUser(user);
        }
        catch (NoSuchUserException e) {
            throw new AuthenticationFailedException(user, tokenStr, message, e);
        }
    }

    User getUser(String userName) throws NoSuchUserException {
        User user = User.getById((String)userName, (boolean)false);
        if (user == null) {
            throw new NoSuchUserException(String.format("No such user %s in the system", userName));
        }
        return user;
    }

    private static String getBaseUrl(HttpServletRequest request) {
        String scheme = request.getScheme() + "://";
        String serverName = request.getServerName();
        String serverPort = request.getServerPort() == 80 ? "" : ":" + request.getServerPort();
        String contextPath = request.getContextPath();
        return scheme + serverName + serverPort + contextPath;
    }

    @Nullable
    private String getLogicalUri(HttpServletRequest request) {
        String uriPathBeforeForwarding = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (uriPathBeforeForwarding == null) {
            return null;
        }
        URI newUri = URI.create(request.getRequestURL().toString());
        try {
            return new URI(newUri.getScheme(), newUri.getAuthority(), uriPathBeforeForwarding, newUri.getQuery(), newUri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            log.log(Level.WARNING, "forwarded request had invalid original URI path: " + uriPathBeforeForwarding);
            return null;
        }
    }

    @CheckForNull
    private String getTokenFromRequest(HttpServletRequest request, HttpServletResponse response, OAuthMessage message) {
        try {
            return message.getToken();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "3-Legged-OAuth Failed to read token from request", e);
            this.sendError(request, response, 500, message);
            OAuthProblemUtils.logOAuthRequest(request, "OAuth authentication FAILED - Unreadable token", log);
            return null;
        }
    }

    private boolean isOauthRequest(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        return StringUtils.startsWithIgnoreCase((CharSequence)authorization, (CharSequence)"OAuth") && this.oAuthRequestUtils.isOAuthAccessAttempt(request);
    }

    private void printMessageToDebug(OAuthMessage message) throws IOException {
        if (!log.isLoggable(Level.FINE)) {
            return;
        }
        StringBuilder sb = new StringBuilder("Validating incoming OAuth request:\n");
        sb.append("\turl: ").append(message.URL).append("\n");
        sb.append("\tmethod: ").append(message.method).append("\n");
        for (Map.Entry entry : message.getParameters()) {
            sb.append("\t").append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append("\n");
        }
        log.log(Level.FINE, sb.toString());
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response, int status, OAuthMessage message) {
        response.setStatus(status);
        try {
            response.addHeader("WWW-Authenticate", message.getAuthorizationHeader(OAuth1Authenticator.getBaseUrl(request)));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failure reporting OAuth error to client", e);
        }
    }

    private void validate3LOMessage(OAuthMessage message, ServiceProviderToken token) throws OAuthException, IOException, URISyntaxException {
        this.printMessageToDebug(message);
        this.validator.validateMessage(message, OAuthConverter.createOAuthAccessor(token));
    }

    private Consumer validateConsumer(OAuthMessage message) throws IOException, OAuthException {
        String consumerKey = message.getConsumerKey();
        return this.consumerStore.get(consumerKey).orElseThrow(() -> {
            log.log(Level.INFO, "Unknown consumer key:'{}' supplied in OAuth request" + consumerKey);
            return new OAuthProblemException("consumer_key_unknown");
        });
    }

    private String verifyToken(OAuthMessage message, String tokenStr) throws OAuthException, IOException, URISyntaxException {
        Optional<ServiceProviderToken> mayBeToken;
        try {
            mayBeToken = this.tokenStore.get(tokenStr);
        }
        catch (InvalidTokenException e) {
            log.log(Level.FINE, String.format("3-Legged-OAuth Consumer provided token [%s] rejected by ServiceProviderTokenStore", tokenStr), e);
            throw new OAuthProblemException("token_rejected");
        }
        if (!mayBeToken.isPresent()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("3-Legged-OAuth token rejected. Service Provider Token, for Consumer provided token [%s], is null", tokenStr));
            }
            throw new OAuthProblemException("token_rejected");
        }
        ServiceProviderToken token = mayBeToken.get();
        if (!token.isAccessToken()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("3-Legged-OAuth token rejected. Service Provider Token, for Consumer provided token [%s], is NOT an access token.", tokenStr));
            }
            throw new OAuthProblemException("token_rejected");
        }
        if (token.getUser() == null) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("3-Legged-OAuth token rejected. Service Provider Token, for Consumer provided token [%s], does not have a corresponding user.", tokenStr));
            }
            throw new OAuthProblemException("No user associated with the token");
        }
        if (!token.getConsumer().getKey().equals(message.getConsumerKey())) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("3-Legged-OAuth token rejected. Service Provider Token, for Consumer provided token [%s], consumer key [%s] does not match request consumer key [%s]", tokenStr, token.getConsumer().getKey(), message.getConsumerKey()));
            }
            throw new OAuthProblemException("token_rejected");
        }
        if (token.hasExpired(this.clock)) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, String.format("3-Legged-OAuth token rejected. Token has expired. Token creation time [%d] time to live [%d] clock (contains logging delay) [%d]", token.getCreationTime(), token.getTimeToLive(), this.clock.millis()));
            }
            throw new OAuthProblemException("token_expired");
        }
        this.validate3LOMessage(message, token);
        this.validateConsumer(message);
        return token.getUser();
    }
}

