/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.Token;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.Consumer;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;

public class OAuthConverter {
    public static OAuthAccessor createOAuthAccessor(ServiceProviderToken token) {
        Objects.requireNonNull(token, "token");
        OAuthAccessor accessor = new OAuthAccessor(OAuthConverter.toOAuthConsumer(token.getConsumer()));
        OAuthConverter.setTokenData(accessor, token);
        return accessor;
    }

    public static OAuthConsumer toOAuthConsumer(Consumer consumer) {
        String callback = consumer.getCallback().map(URI::toString).orElse(null);
        OAuthConsumer oauthConsumer = new OAuthConsumer(callback, consumer.getKey(), (String)consumer.getConsumerSecret().orElse(null), null);
        oauthConsumer.setProperty("name", (Object)consumer.getName());
        oauthConsumer.setProperty("description", consumer.getDescription());
        if (consumer.getSignatureMethod() == Consumer.SignatureMethod.RSA_SHA1) {
            oauthConsumer.setProperty("oauth_signature_method", (Object)"RSA-SHA1");
            oauthConsumer.setProperty("RSA-SHA1.PublicKey", consumer.getPublicKey());
        } else {
            oauthConsumer.setProperty("oauth_signature_method", (Object)"HMAC-SHA1");
        }
        return oauthConsumer;
    }

    private static void setTokenData(OAuthAccessor accessor, ServiceProviderToken token) {
        OAuthConverter.setCommonTokenData(accessor, token);
        if (token.isRequestToken()) {
            if (token.getAuthorization() == ServiceProviderToken.Authorization.AUTHORIZED) {
                accessor.setProperty("user", (Object)token.getUser());
                accessor.setProperty("authorized", (Object)true);
            } else if (token.getAuthorization() == ServiceProviderToken.Authorization.DENIED) {
                accessor.setProperty("user", (Object)token.getUser());
                accessor.setProperty("authorized", (Object)false);
            }
        } else {
            accessor.accessToken = token.getToken();
            accessor.setProperty("user", (Object)token.getUser());
            accessor.setProperty("authorized", (Object)true);
        }
        accessor.tokenSecret = token.getTokenSecret();
        accessor.setProperty("creationTime", (Object)token.getCreationTime());
    }

    private static void setCommonTokenData(OAuthAccessor accessor, Token token) {
        if (token.isRequestToken()) {
            accessor.requestToken = token.getToken();
        } else {
            accessor.accessToken = token.getToken();
        }
        accessor.tokenSecret = token.getTokenSecret();
        for (Map.Entry<String, String> property : token.getProperties().entrySet()) {
            accessor.setProperty(property.getKey(), (Object)property.getValue());
        }
    }

    public static final class ConsumerProperty {
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
    }

    private static final class AccessorProperty {
        private static final String USER = "user";
        private static final String AUTHORIZED = "authorized";
        private static final String VERIFIER = "verifier";
        private static final String CALLBACK = "callback";
        private static final String CREATION_TIME = "creationTime";

        private AccessorProperty() {
        }
    }
}

