/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger.register;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketCapabilitiesClient;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketWebhookClient;
import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketMissingCapabilityException;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketWebhook;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketWebhookRequest;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.BitbucketWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.register.WebhookHandler;
import com.atlassian.bitbucket.jenkins.internal.trigger.register.WebhookRegisterRequest;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class BitbucketWebhookHandler
implements WebhookHandler {
    private static final String CALLBACK_URL_SUFFIX = "bitbucket-server-webhook/trigger";
    private static final Logger LOGGER = Logger.getLogger(BitbucketWebhookHandler.class.getName());
    private final BitbucketCapabilitiesClient serverCapabilities;
    private final BitbucketWebhookClient webhookClient;

    public BitbucketWebhookHandler(BitbucketCapabilitiesClient serverCapabilities, BitbucketWebhookClient webhookClient) {
        this.serverCapabilities = serverCapabilities;
        this.webhookClient = webhookClient;
    }

    @Override
    @Nullable
    public BitbucketWebhook register(WebhookRegisterRequest request) {
        Collection<BitbucketWebhookEvent> events = this.getEvents(request);
        if (events.isEmpty()) {
            return null;
        }
        return this.process(request, events);
    }

    private String constructCallbackUrl(WebhookRegisterRequest request) {
        String jenkinsUrl = request.getJenkinsUrl();
        StringBuilder url = new StringBuilder(request.getJenkinsUrl());
        if (!jenkinsUrl.endsWith("/")) {
            url.append("/");
        }
        return url.append(CALLBACK_URL_SUFFIX).toString();
    }

    private BitbucketWebhookRequest createRequest(WebhookRegisterRequest request, Collection<BitbucketWebhookEvent> events) {
        return new BitbucketWebhookRequest.Builder(events.stream().map(BitbucketWebhookEvent::getEventId).collect(Collectors.toSet())).withCallbackTo(this.constructCallbackUrl(request)).name(request.getName()).build();
    }

    private void deleteWebhooks(List<BitbucketWebhook> webhooks) {
        webhooks.stream().map(BitbucketWebhook::getId).peek(id -> LOGGER.info("Deleting obsolete webhook" + id)).forEach(this.webhookClient::deleteWebhook);
    }

    private Collection<BitbucketWebhookEvent> getEvents(WebhookRegisterRequest request) {
        Set<String> hooks;
        HashSet<BitbucketWebhookEvent> supportedEvents = new HashSet<BitbucketWebhookEvent>();
        try {
            hooks = this.serverCapabilities.getWebhookSupportedEvents().getApplicationWebHooks();
        }
        catch (BitbucketMissingCapabilityException e) {
            hooks = new HashSet<String>();
        }
        if (request.isMirror() && hooks.contains(BitbucketWebhookEvent.MIRROR_SYNCHRONIZED.getEventId())) {
            supportedEvents.add(BitbucketWebhookEvent.MIRROR_SYNCHRONIZED);
        } else if (request.isTriggerOnRefChange()) {
            supportedEvents.add(BitbucketWebhookEvent.REPO_REF_CHANGE);
        }
        if (request.isTriggerOnPullRequest()) {
            supportedEvents.add(BitbucketWebhookEvent.PULL_REQUEST_DECLINED);
            supportedEvents.add(BitbucketWebhookEvent.PULL_REQUEST_DELETED);
            if (!request.isMirror() && hooks.contains(BitbucketWebhookEvent.PULL_REQUEST_FROM_REF_UPDATED.getEventId())) {
                supportedEvents.add(BitbucketWebhookEvent.PULL_REQUEST_FROM_REF_UPDATED);
            }
            supportedEvents.add(BitbucketWebhookEvent.PULL_REQUEST_MERGED);
            supportedEvents.add(BitbucketWebhookEvent.PULL_REQUEST_OPENED);
        }
        return supportedEvents;
    }

    private BitbucketWebhook process(WebhookRegisterRequest request, Collection<BitbucketWebhookEvent> events) {
        Optional<BitbucketWebhook> foundWebook;
        String callback = this.constructCallbackUrl(request);
        List webhooks = this.webhookClient.getWebhooks(new String[0]).collect(Collectors.toList());
        List<BitbucketWebhook> serverSideWebhooks = webhooks.stream().filter(hook -> hook.getName().equals(request.getName()) && hook.getUrl().equals(callback)).collect(Collectors.toList());
        HashSet<BitbucketWebhookEvent> desiredEvents = new HashSet<BitbucketWebhookEvent>(events);
        Set serverSideWebhookEvents = serverSideWebhooks.stream().flatMap(event -> event.getEvents().stream().map(BitbucketWebhookEvent::findByEventId)).collect(Collectors.toSet());
        desiredEvents.addAll(serverSideWebhookEvents);
        if (serverSideWebhookEvents.containsAll(desiredEvents) && serverSideWebhookEvents.size() == desiredEvents.size() && (foundWebook = serverSideWebhooks.stream().filter(event -> event.isActive() && callback.equalsIgnoreCase(event.getUrl())).findFirst()).isPresent()) {
            return foundWebook.get();
        }
        if (serverSideWebhooks.isEmpty()) {
            BitbucketWebhookRequest webhook = this.createRequest(request, desiredEvents);
            BitbucketWebhook result = this.webhookClient.registerWebhook(webhook);
            LOGGER.info("New Webhook registered - " + String.valueOf(result));
            return result;
        }
        return this.update(serverSideWebhooks, request, desiredEvents);
    }

    private BitbucketWebhook update(List<BitbucketWebhook> webhooks, WebhookRegisterRequest request, Collection<BitbucketWebhookEvent> toSubscribe) {
        if (!webhooks.isEmpty()) {
            BitbucketWebhook webhook = this.updateRemoteWebhook(webhooks.get(0), request, toSubscribe);
            if (webhooks.size() > 1) {
                this.deleteWebhooks(webhooks.subList(1, webhooks.size()));
            }
            return webhook;
        }
        throw new IllegalArgumentException("Empty list of webhooks provided, need at least one to update");
    }

    private BitbucketWebhook updateRemoteWebhook(BitbucketWebhook existing, WebhookRegisterRequest request, Collection<BitbucketWebhookEvent> toSubscribe) {
        BitbucketWebhookRequest r = this.createRequest(request, toSubscribe);
        BitbucketWebhook updated = this.webhookClient.updateWebhook(existing.getId(), r);
        LOGGER.info(String.format("Existing webhook updated - %s with new webhook %s", existing, r));
        return updated;
    }
}

