/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger.events;

import com.atlassian.bitbucket.jenkins.internal.model.BitbucketUser;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class AbstractWebhookEvent {
    private final BitbucketUser actor;
    private final Date date;
    private final String eventKey;

    public AbstractWebhookEvent(@Nullable BitbucketUser actor, String eventKey, Date date) {
        this.actor = actor;
        this.eventKey = Objects.requireNonNull(eventKey, "eventKey");
        this.date = Objects.requireNonNull(date, "date");
    }

    public Optional<BitbucketUser> getActor() {
        return Optional.ofNullable(this.actor);
    }

    public Date getDate() {
        return new Date(this.date.getTime());
    }

    public String getEventKey() {
        return this.eventKey;
    }
}

