/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger;

import com.atlassian.bitbucket.jenkins.internal.model.BitbucketUser;
import hudson.model.Action;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class BitbucketWebhookTriggerRequest {
    private final BitbucketUser actor;
    private final List<Action> additionalActions;

    private BitbucketWebhookTriggerRequest(Builder builder) {
        this.actor = builder.actor;
        this.additionalActions = builder.additionalActions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitbucketWebhookTriggerRequest that = (BitbucketWebhookTriggerRequest)o;
        return Objects.equals(this.actor, that.actor) && Objects.equals(this.additionalActions, that.additionalActions);
    }

    public Optional<BitbucketUser> getActor() {
        return Optional.ofNullable(this.actor);
    }

    public List<Action> getAdditionalActions() {
        return this.additionalActions;
    }

    public int hashCode() {
        return Objects.hash(this.actor, this.additionalActions);
    }

    public static final class Builder {
        private final List<Action> additionalActions = new ArrayList<Action>();
        private BitbucketUser actor;

        public Builder actor(@Nullable BitbucketUser value) {
            this.actor = value;
            return this;
        }

        public Builder additionalActions(Action ... additionalActions) {
            this.additionalActions.addAll(Arrays.asList(additionalActions));
            return this;
        }

        public BitbucketWebhookTriggerRequest build() {
            return new BitbucketWebhookTriggerRequest(this);
        }
    }
}

