/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.trigger;

import com.atlassian.bitbucket.jenkins.internal.client.exception.BitbucketClientException;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketPluginConfiguration;
import com.atlassian.bitbucket.jenkins.internal.config.BitbucketServerConfiguration;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketWebhook;
import com.atlassian.bitbucket.jenkins.internal.provider.JenkinsProvider;
import com.atlassian.bitbucket.jenkins.internal.provider.JenkinsProviderModule;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketTriggerWorker;
import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookTrigger;
import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookTriggerCause;
import com.atlassian.bitbucket.jenkins.internal.trigger.BitbucketWebhookTriggerRequest;
import com.atlassian.bitbucket.jenkins.internal.trigger.Messages;
import com.atlassian.bitbucket.jenkins.internal.trigger.RetryingWebhookHandler;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.AbstractWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestFromRefUpdatedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestOpenedWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.PullRequestWebhookEvent;
import com.atlassian.bitbucket.jenkins.internal.trigger.events.RefsChangedWebhookEvent;
import com.google.inject.Guice;
import com.google.inject.Module;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.NamingThreadFactory;
import hudson.util.SequentialExecutionQueue;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.triggers.SCMTriggerItem;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.cps.CpsScmFlowDefinition;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class BitbucketWebhookTriggerImpl
extends Trigger<Job<?, ?>>
implements BitbucketWebhookTrigger {
    private static final int BUILD_ON_PULL_REQUEST_VERSION = 1;
    private static final Logger LOGGER = Logger.getLogger(BitbucketWebhookTriggerImpl.class.getName());
    private final boolean pullRequestTrigger;
    private final boolean refTrigger;
    private final int version;

    @DataBoundConstructor
    public BitbucketWebhookTriggerImpl(boolean pullRequestTrigger, boolean refTrigger) {
        this.version = 1;
        this.pullRequestTrigger = pullRequestTrigger;
        this.refTrigger = refTrigger;
    }

    public BitbucketWebhookTriggerDescriptor getDescriptor() {
        return (BitbucketWebhookTriggerDescriptor)super.getDescriptor();
    }

    @Override
    public boolean isApplicableForEvent(AbstractWebhookEvent event) {
        if (event instanceof PullRequestWebhookEvent) {
            if (this.isPullRequestTrigger()) {
                return event instanceof PullRequestOpenedWebhookEvent || event instanceof PullRequestFromRefUpdatedWebhookEvent;
            }
        } else if (event instanceof RefsChangedWebhookEvent) {
            return this.isRefTrigger();
        }
        return false;
    }

    public boolean isPullRequestTrigger() {
        return this.pullRequestTrigger;
    }

    public boolean isRefTrigger() {
        if (this.version < 1) {
            return true;
        }
        return this.refTrigger;
    }

    public void start(Job<?, ?> project, boolean newInstance) {
        super.start(project, newInstance);
        if (this.skipWebhookRegistration(project, newInstance)) {
            return;
        }
        SCMTriggerItem triggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)this.job);
        if (this.isWorkflowJob(triggerItem)) {
            BitbucketWebhookTriggerDescriptor descriptor = this.getDescriptor();
            Optional<SCM> maybeScm = this.fetchWorkflowSCM(triggerItem);
            maybeScm.ifPresent(scm -> {
                if (scm instanceof BitbucketSCM) {
                    boolean isAdded = descriptor.addTrigger((Item)project, (BitbucketSCM)((Object)scm), this.pullRequestTrigger, this.refTrigger);
                    ((BitbucketSCM)((Object)scm)).setWebhookRegistered(isAdded);
                }
            });
        } else if (triggerItem != null) {
            BitbucketWebhookTriggerDescriptor descriptor = this.getDescriptor();
            triggerItem.getSCMs().stream().filter(BitbucketSCM.class::isInstance).map(BitbucketSCM.class::cast).filter(scm -> !scm.isWebhookRegistered()).filter(scm -> !this.checkTriggerExists(descriptor, (BitbucketSCM)((Object)scm))).forEach(scm -> {
                boolean isAdded = descriptor.addTrigger((Item)project, (BitbucketSCM)((Object)scm), this.pullRequestTrigger, this.refTrigger);
                scm.setWebhookRegistered(isAdded);
            });
        }
    }

    @Override
    public void trigger(BitbucketWebhookTriggerRequest triggerRequest) {
        SCMTriggerItem triggerItem = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)this.job);
        if (triggerItem != null) {
            this.getDescriptor().schedule((Job)this.job, triggerItem, triggerRequest);
        }
    }

    Optional<SCM> fetchWorkflowSCM(SCMTriggerItem triggerItem) {
        if (((WorkflowJob)triggerItem).getDefinition() instanceof CpsScmFlowDefinition) {
            return Optional.of(((CpsScmFlowDefinition)((WorkflowJob)triggerItem).getDefinition()).getScm());
        }
        return Optional.empty();
    }

    boolean isWorkflowJob(@Nullable SCMTriggerItem triggerItem) {
        return triggerItem instanceof WorkflowJob;
    }

    boolean skipWebhookRegistration(Job<?, ?> project, boolean newInstance) {
        return !newInstance && !(project instanceof WorkflowJob);
    }

    private boolean checkTriggerExists(BitbucketWebhookTriggerDescriptor descriptor, BitbucketSCM scm) {
        boolean isExists = descriptor.webhookExists((Job)this.job, scm);
        if (isExists) {
            scm.setWebhookRegistered(true);
        }
        return isExists;
    }

    @Symbol(value={"BitbucketWebhookTriggerImpl"})
    @Extension
    public static class BitbucketWebhookTriggerDescriptor
    extends TriggerDescriptor {
        private static final int MAX_THREADS = 10;
        private final transient SequentialExecutionQueue queue;
        @Inject
        private BitbucketPluginConfiguration bitbucketPluginConfiguration;
        private transient JenkinsProvider jenkinsProvider;
        @Inject
        private RetryingWebhookHandler retryingWebhookHandler;

        public BitbucketWebhookTriggerDescriptor() {
            this.queue = BitbucketWebhookTriggerDescriptor.createSequentialQueue();
        }

        public BitbucketWebhookTriggerDescriptor(SequentialExecutionQueue queue, RetryingWebhookHandler webhookHandler, JenkinsProvider jenkinsProvider, BitbucketPluginConfiguration bitbucketPluginConfiguration) {
            this.queue = queue;
            this.retryingWebhookHandler = webhookHandler;
            this.jenkinsProvider = jenkinsProvider;
            this.bitbucketPluginConfiguration = bitbucketPluginConfiguration;
        }

        public String getDisplayName() {
            return Messages.BitbucketWebhookTrigger_displayname();
        }

        public boolean isApplicable(Item item) {
            return SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)item) != null;
        }

        public Trigger<?> newInstance(@Nullable StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (Trigger)super.newInstance(req, formData);
        }

        public void schedule(@Nullable Job<?, ?> job, SCMTriggerItem triggerItem, BitbucketWebhookTriggerRequest triggerRequest) {
            CauseAction causeAction = new CauseAction((Cause)new BitbucketWebhookTriggerCause(triggerRequest));
            this.queue.execute((Runnable)new BitbucketTriggerWorker(job, triggerItem, (Action)causeAction, triggerRequest.getAdditionalActions()));
        }

        @Inject
        public void setJenkinsProvider(JenkinsProvider jenkinsProvider) {
            this.jenkinsProvider = jenkinsProvider;
        }

        private static SequentialExecutionQueue createSequentialQueue() {
            return new SequentialExecutionQueue(Executors.newFixedThreadPool(10, (ThreadFactory)new NamingThreadFactory(Executors.defaultThreadFactory(), "BitbucketWebhookTrigger")));
        }

        private static boolean isTriggerEnabled(ParameterizedJobMixIn.ParameterizedJob job) {
            return job.getTriggers().values().stream().anyMatch(v -> v instanceof BitbucketWebhookTriggerImpl);
        }

        private boolean addTrigger(Item item, BitbucketSCM scm, boolean pullRequest, boolean refChange) {
            try {
                scm.getRepositories().forEach(repo -> this.registerWebhook(item, (BitbucketSCMRepository)repo, pullRequest, refChange));
                return true;
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "There was a problem while trying to add webhook", ex);
                throw ex;
            }
        }

        private BitbucketServerConfiguration getServer(@CheckForNull String serverId) {
            return this.bitbucketPluginConfiguration.getServerById(serverId).orElseThrow(() -> new BitbucketClientException("Server config not found for input server id" + serverId));
        }

        private boolean isExistingWebhookOnRepo(BitbucketSCM scm, BitbucketSCMRepository repository) {
            return scm.isWebhookRegistered() && scm.getRepositories().stream().allMatch(r -> r.getServerId().equals(repository.getServerId()) && r.getProjectKey().equals(repository.getProjectKey()) && r.getRepositorySlug().equals(repository.getRepositorySlug()) && !this.isMirrorConfigurationDifferent((BitbucketSCMRepository)r));
        }

        private boolean isMirrorConfigurationDifferent(BitbucketSCMRepository r) {
            return StringUtils.isEmpty((CharSequence)r.getMirrorName()) ^ StringUtils.isEmpty((CharSequence)r.getMirrorName());
        }

        private void registerWebhook(Item item, BitbucketSCMRepository repository, boolean pullRequest, boolean refChange) {
            BitbucketServerConfiguration bitbucketServerConfiguration = this.getServer(repository.getServerId());
            BitbucketWebhook webhook = this.retryingWebhookHandler.register(bitbucketServerConfiguration.getBaseUrl(), bitbucketServerConfiguration.getGlobalCredentialsProvider(item), repository, item, pullRequest, refChange);
            LOGGER.info("Webhook returned -" + String.valueOf(webhook));
        }

        private boolean webhookExists(@CheckForNull Job<?, ?> project, BitbucketSCM input) {
            try (ACLContext ctx = ACL.as((Authentication)ACL.SYSTEM);){
                if (this.jenkinsProvider == null) {
                    Guice.createInjector((Module[])new Module[]{new JenkinsProviderModule()}).injectMembers((Object)this);
                }
                boolean bl = this.jenkinsProvider.get().getAllItems(ParameterizedJobMixIn.ParameterizedJob.class).stream().filter(item -> !item.equals(project)).filter(BitbucketWebhookTriggerDescriptor::isTriggerEnabled).map(item -> SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)item)).filter(Objects::nonNull).map(scmItem -> scmItem.getSCMs()).flatMap(Collection::stream).filter(scm -> scm instanceof BitbucketSCM).map(scm -> ((BitbucketSCM)((Object)scm)).getRepositories()).flatMap(Collection::stream).anyMatch(scm -> this.isExistingWebhookOnRepo(input, (BitbucketSCMRepository)scm));
                return bl;
            }
        }
    }
}

