/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.status;

import com.atlassian.bitbucket.jenkins.internal.provider.GlobalLibrariesProvider;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketPullRequestSCMHead;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepositoryHelper;
import com.atlassian.bitbucket.jenkins.internal.status.BitbucketRevisionAction;
import com.atlassian.bitbucket.jenkins.internal.status.BuildStatusPoster;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.util.DescribableList;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import jenkins.branch.Branch;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMHead;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.workflow.libs.FolderLibraries;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.SCMRetriever;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

@Extension
public class LocalSCMListener
extends SCMListener {
    public static final String BRANCH_PREFIX = "refs/heads/";
    public static final String TAG_PREFIX = "refs/tags/";
    private BuildStatusPoster buildStatusPoster;
    private GlobalLibrariesProvider librariesProvider;
    private BitbucketSCMRepositoryHelper repositoryHelper;

    public LocalSCMListener() {
    }

    @Inject
    LocalSCMListener(BuildStatusPoster buildStatusPoster, GlobalLibrariesProvider librariesProvider, BitbucketSCMRepositoryHelper repositoryHelper) {
        this.buildStatusPoster = buildStatusPoster;
        this.librariesProvider = librariesProvider;
        this.repositoryHelper = repositoryHelper;
    }

    @CheckForNull
    public GitSCM getUnderlyingGitSCM(SCM scm) {
        BitbucketSCM bitbucketSCM;
        if (scm instanceof GitSCM) {
            return (GitSCM)scm;
        }
        if (scm instanceof BitbucketSCM && (bitbucketSCM = (BitbucketSCM)scm).getServerId() != null) {
            return bitbucketSCM.getGitSCM();
        }
        return null;
    }

    public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState pollingBaseline) {
        if (build.getParent().getParent() instanceof Folder && this.isFolderLib((Folder)build.getParent().getParent(), scm)) {
            return;
        }
        if (build.getParent().getParent() instanceof WorkflowMultiBranchProject && this.projectHasFolderLibrary((WorkflowMultiBranchProject)build.getParent().getParent(), scm)) {
            return;
        }
        for (LibraryConfiguration cfg : this.librariesProvider.get().getLibraries()) {
            SCMRetriever retriever;
            if (!(cfg.getRetriever() instanceof SCMRetriever) || !((retriever = (SCMRetriever)cfg.getRetriever()).getScm() instanceof BitbucketSCM) || !(scm instanceof BitbucketSCM)) continue;
            BitbucketSCM libraryScm = (BitbucketSCM)retriever.getScm();
            BitbucketSCM bitbucketScm = (BitbucketSCM)scm;
            if (!libraryScm.getId().equals(bitbucketScm.getId())) continue;
            return;
        }
        BitbucketSCMRepository bitbucketSCMRepository = this.repositoryHelper.getRepository(build, scm);
        if (bitbucketSCMRepository == null) {
            return;
        }
        GitSCM underlyingScm = this.getUnderlyingGitSCM(scm);
        if (underlyingScm == null) {
            return;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        this.buildEnvironment(underlyingScm, build, env);
        String refName = this.getRefFromEnvironment(env, underlyingScm);
        BitbucketRevisionAction revisionAction = new BitbucketRevisionAction(bitbucketSCMRepository, refName, this.getCommitFromEnvironment(env));
        build.addAction((Action)revisionAction);
        this.buildStatusPoster.postBuildStatus(revisionAction, build, listener);
    }

    private void buildEnvironment(GitSCM underlyingScm, Run<?, ?> build, Map<String, String> env) {
        Branch branch;
        SCMHead head;
        BranchProjectFactory projectFactory;
        underlyingScm.buildEnvironment(build, env);
        Job job = build.getParent();
        ItemGroup parent = job.getParent();
        if (parent instanceof MultiBranchProject && (projectFactory = ((MultiBranchProject)parent).getProjectFactory()).isProject((Item)job) && (head = (branch = projectFactory.getBranch(job)).getHead()) instanceof BitbucketPullRequestSCMHead) {
            BitbucketPullRequestSCMHead prHead = (BitbucketPullRequestSCMHead)head;
            env.put("GIT_BRANCH", prHead.getOriginName());
        }
    }

    private String getCommitFromEnvironment(Map<String, String> env) {
        String commit = env.get("PULL_REQUEST_SOURCE_COMMIT");
        if (commit == null) {
            commit = env.get("GIT_COMMIT");
        }
        return commit;
    }

    @CheckForNull
    private String getRefFromEnvironment(Map<String, String> env, GitSCM scm) {
        if (StringUtils.isNotBlank((CharSequence)env.get("PULL_REQUEST_SOURCE_COMMIT"))) {
            return null;
        }
        String refId = StringUtils.stripToNull((String)env.get("GIT_BRANCH"));
        if (refId == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)env.get("TAG_SOURCE_COMMIT"))) {
            return env.get("TAG_SOURCE_COMMIT");
        }
        return BRANCH_PREFIX + scm.deriveLocalBranchName(refId);
    }

    private boolean isFolderLib(Folder folder, SCM scm) {
        if (this.isScmFolderLibrary(scm, folder.getProperties())) {
            return true;
        }
        if (folder.getParent() instanceof Folder) {
            return this.isFolderLib((Folder)folder.getParent(), scm);
        }
        return false;
    }

    private boolean isScmFolderLibrary(SCM scm, DescribableList<AbstractFolderProperty<?>, AbstractFolderPropertyDescriptor> properties) {
        for (Object folderItem : properties) {
            if (!(folderItem instanceof FolderLibraries)) continue;
            FolderLibraries folderLibraries = (FolderLibraries)folderItem;
            for (LibraryConfiguration folderLib : folderLibraries.getLibraries()) {
                SCMRetriever retriever;
                if (!(folderLib.getRetriever() instanceof SCMRetriever) || !((retriever = (SCMRetriever)folderLib.getRetriever()).getScm() instanceof BitbucketSCM) || !(scm instanceof BitbucketSCM)) continue;
                BitbucketSCM libraryScm = (BitbucketSCM)retriever.getScm();
                BitbucketSCM bitbucketScm = (BitbucketSCM)scm;
                if (!libraryScm.getId().equals(bitbucketScm.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean projectHasFolderLibrary(WorkflowMultiBranchProject project, SCM scm) {
        if (this.isScmFolderLibrary(scm, project.getProperties())) {
            return true;
        }
        if (project.getParent() instanceof Folder) {
            return this.isFolderLib((Folder)project.getParent(), scm);
        }
        return false;
    }
}

