/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.scm;

import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCM;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMSource;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.inject.Singleton;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProject;
import jenkins.triggers.SCMTriggerItem;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

@Singleton
public class BitbucketSCMRepositoryHelper {
    @CheckForNull
    public BitbucketSCMRepository getRepository(Run<?, ?> build, SCM scm) {
        if (!(scm instanceof GitSCM) && !(scm instanceof BitbucketSCM)) {
            return null;
        }
        if (scm instanceof BitbucketSCM) {
            return ((BitbucketSCM)scm).getBitbucketSCMRepository();
        }
        if (this.isWorkflowRun(build)) {
            Job job = build.getParent();
            GitSCM gitScm = (GitSCM)scm;
            ItemGroup<?> parent = this.getJobParent(job);
            if (parent instanceof MultiBranchProject) {
                return ((MultiBranchProject)parent).getSources().stream().map(BranchSource::getSource).filter(BitbucketSCMSource.class::isInstance).map(BitbucketSCMSource.class::cast).filter(bbsSource -> this.filterSource(gitScm, (BitbucketSCMSource)((Object)bbsSource))).findFirst().map(BitbucketSCMSource::getBitbucketSCMRepository).orElse(null);
            }
            if (job instanceof SCMTriggerItem) {
                SCMTriggerItem scmItem = (SCMTriggerItem)job;
                return scmItem.getSCMs().stream().filter(BitbucketSCM.class::isInstance).map(BitbucketSCM.class::cast).filter(bScm -> {
                    GitSCM bGitScm = bScm.getGitSCM();
                    return bGitScm != null && Objects.equals(bGitScm.getKey(), scm.getKey());
                }).findFirst().map(BitbucketSCM::getBitbucketSCMRepository).orElse(null);
            }
        }
        return null;
    }

    ItemGroup<?> getJobParent(Job<?, ?> job) {
        return job.getParent();
    }

    boolean isWorkflowRun(Run<?, ?> build) {
        return build instanceof WorkflowRun;
    }

    boolean filterSource(GitSCM gitScm, BitbucketSCMSource bbsSource) {
        return gitScm.getUserRemoteConfigs().stream().anyMatch(userRemoteConfig -> Objects.equals(userRemoteConfig.getUrl(), bbsSource.getRemote()));
    }
}

