/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model.deployment;

import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironment;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.DeploymentState;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BitbucketDeployment {
    private static final String DEPLOYMENT_SEQUENCE_NUMBER = "deploymentSequenceNumber";
    private static final String DESCRIPTION = "description";
    private static final String DISPLAY_NAME = "displayName";
    private static final String ENVIRONMENT = "environment";
    private static final String KEY = "key";
    private static final String STATE = "state";
    private static final String URL = "url";
    private final long deploymentSequenceNumber;
    private final String description;
    private final String displayName;
    private final BitbucketDeploymentEnvironment environment;
    private final String key;
    private final DeploymentState state;
    private final String url;

    @JsonCreator
    public BitbucketDeployment(@JsonProperty(value="deploymentSequenceNumber") long deploymentSequenceNumber, @JsonProperty(value="description") String description, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="environment") BitbucketDeploymentEnvironment environment, @JsonProperty(value="key") String key, @JsonProperty(value="state") DeploymentState state, @JsonProperty(value="url") String url) {
        this.deploymentSequenceNumber = deploymentSequenceNumber;
        this.description = Objects.requireNonNull(description, DESCRIPTION);
        this.displayName = Objects.requireNonNull(displayName, DISPLAY_NAME);
        this.environment = Objects.requireNonNull(environment, ENVIRONMENT);
        this.key = Objects.requireNonNull(key, KEY);
        this.state = Objects.requireNonNull(state, STATE);
        this.url = Objects.requireNonNull(url, URL);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BitbucketDeployment that = (BitbucketDeployment)o;
        return this.deploymentSequenceNumber == that.deploymentSequenceNumber && Objects.equals(this.description, that.description) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.environment, that.environment) && Objects.equals(this.key, that.key) && this.state == that.state && Objects.equals(this.url, that.url);
    }

    @JsonProperty(value="deploymentSequenceNumber")
    public long getDeploymentSequenceNumber() {
        return this.deploymentSequenceNumber;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @JsonProperty(value="environment")
    public BitbucketDeploymentEnvironment getEnvironment() {
        return this.environment;
    }

    @JsonProperty(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="state")
    public DeploymentState getState() {
        return this.state;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deploymentSequenceNumber, this.description, this.displayName, this.environment, this.key, this.state, this.url});
    }

    public String toString() {
        return "BitbucketDeployment{deploymentSequenceNumber=" + this.deploymentSequenceNumber + ", description='" + this.description + "', displayName='" + this.displayName + "', environment=" + String.valueOf(this.environment) + ", key='" + this.key + "', state=" + String.valueOf((Object)this.state) + ", url='" + this.url + "'}";
    }
}

