/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.model;

import com.atlassian.bitbucket.jenkins.internal.model.BitbucketMirror;
import com.atlassian.bitbucket.jenkins.internal.model.BitbucketNamedLink;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BitbucketMirroredRepositoryDescriptor {
    private final Map<String, List<BitbucketNamedLink>> links;
    private final BitbucketMirror mirrorServer;

    @JsonCreator
    public BitbucketMirroredRepositoryDescriptor(@JsonProperty(value="links", required=true) Map<String, List<BitbucketNamedLink>> links, @JsonProperty(value="mirrorServer", required=true) BitbucketMirror mirrorServer) {
        this.links = Objects.requireNonNull(links, "links");
        this.mirrorServer = Objects.requireNonNull(mirrorServer, "mirrorServer");
    }

    public BitbucketMirror getMirrorServer() {
        return this.mirrorServer;
    }

    public Map<String, List<BitbucketNamedLink>> getLinks() {
        return this.links;
    }

    @Nullable
    public String getSelfLink() {
        List<BitbucketNamedLink> link = this.links.get("self");
        if (link != null && !link.isEmpty()) {
            return link.get(0).getHref();
        }
        return null;
    }
}

