/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.deployments;

import com.atlassian.bitbucket.jenkins.internal.deployments.BitbucketDeploymentFactory;
import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentPoster;
import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentStep;
import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentStepDescriptorHelper;
import com.atlassian.bitbucket.jenkins.internal.deployments.DeploymentStepUtils;
import com.atlassian.bitbucket.jenkins.internal.deployments.Messages;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeployment;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironment;
import com.atlassian.bitbucket.jenkins.internal.model.deployment.BitbucketDeploymentEnvironmentType;
import com.atlassian.bitbucket.jenkins.internal.scm.BitbucketSCMRepository;
import com.atlassian.bitbucket.jenkins.internal.status.BitbucketRevisionAction;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class DeploymentNotifier
extends Notifier
implements SimpleBuildStep,
DeploymentStep {
    private static final Logger LOGGER = Logger.getLogger(DeploymentNotifier.class.getName());
    private final String environmentName;
    private String environmentKey = DeploymentStepUtils.getOrGenerateEnvironmentKey();
    private BitbucketDeploymentEnvironmentType environmentType;
    private String environmentUrl;

    @DataBoundConstructor
    public DeploymentNotifier(@CheckForNull String environmentName) {
        this.environmentName = StringUtils.stripToNull((String)environmentName);
    }

    public DescriptorImpl descriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorByType(DescriptorImpl.class);
    }

    @Override
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    @DataBoundSetter
    public void setEnvironmentKey(@CheckForNull String environmentKey) {
        this.environmentKey = DeploymentStepUtils.getOrGenerateEnvironmentKey(environmentKey);
    }

    @Override
    @CheckForNull
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Override
    @CheckForNull
    public String getEnvironmentType() {
        return this.environmentType == null ? null : this.environmentType.name();
    }

    @DataBoundSetter
    public void setEnvironmentType(@CheckForNull String environmentType) {
        this.environmentType = DeploymentStepUtils.normalizeEnvironmentType(environmentType);
    }

    @Override
    @CheckForNull
    public String getEnvironmentUrl() {
        return this.environmentUrl;
    }

    @DataBoundSetter
    public void setEnvironmentUrl(@CheckForNull String environmentUrl) {
        this.environmentUrl = StringUtils.stripToNull((String)environmentUrl);
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        try {
            BitbucketRevisionAction revisionAction = (BitbucketRevisionAction)run.getAction(BitbucketRevisionAction.class);
            if (revisionAction == null) {
                listener.error("Could not send deployment notification: DeploymentNotifier only works when using the Bitbucket SCM for checkout.");
                return;
            }
            BitbucketDeploymentEnvironment environment = this.getEnvironment(run, listener);
            BitbucketDeployment deployment = this.descriptor().getBitbucketDeploymentFactory().createDeployment(run, environment);
            BitbucketSCMRepository bitbucketSCMRepo = revisionAction.getBitbucketSCMRepo();
            String revisionSha = revisionAction.getRevisionSha1();
            this.descriptor().getDeploymentPoster().postDeployment(bitbucketSCMRepo, revisionSha, deployment, run, listener);
        }
        catch (RuntimeException e) {
            String errorMsg = String.format("An error occurred when trying to post the deployment to Bitbucket Server: %s", e.getMessage());
            listener.error(errorMsg);
            LOGGER.info(errorMsg);
            LOGGER.log(Level.FINE, "Stacktrace from deployment post failure", e);
        }
    }

    @Override
    public BitbucketDeploymentEnvironment getEnvironment(Run<?, ?> run, TaskListener listener) {
        return DeploymentStepUtils.getEnvironment(this, run, listener);
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private static final FormValidation FORM_VALIDATION_OK = FormValidation.ok();
        @Inject
        private BitbucketDeploymentFactory bitbucketDeploymentFactory;
        @Inject
        private DeploymentPoster deploymentPoster;
        @Inject
        private DeploymentStepDescriptorHelper descriptorHelper;

        @POST
        public FormValidation doCheckEnvironmentKey(@AncestorInPath @CheckForNull Item context, @QueryParameter @CheckForNull String environmentKey) {
            return this.descriptorHelper.doCheckEnvironmentKey(context, environmentKey);
        }

        @POST
        public FormValidation doCheckEnvironmentName(@AncestorInPath Item context, @QueryParameter String environmentName) {
            return this.descriptorHelper.doCheckEnvironmentName(context, environmentName);
        }

        @POST
        public FormValidation doCheckEnvironmentType(@AncestorInPath Item context, @QueryParameter String environmentType) {
            return this.descriptorHelper.doCheckEnvironmentType(context, environmentType);
        }

        @POST
        public FormValidation doCheckEnvironmentUrl(@AncestorInPath Item context, @QueryParameter String environmentUrl) {
            return this.descriptorHelper.doCheckEnvironmentUrl(context, environmentUrl);
        }

        @POST
        public ListBoxModel doFillEnvironmentTypeItems(@AncestorInPath Item context) {
            return this.descriptorHelper.doFillEnvironmentTypeItems(context);
        }

        public BitbucketDeploymentFactory getBitbucketDeploymentFactory() {
            return this.bitbucketDeploymentFactory;
        }

        public DeploymentPoster getDeploymentPoster() {
            return this.deploymentPoster;
        }

        public String getDisplayName() {
            return Messages.DeploymentNotifier_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

