/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.client;

import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactory;
import com.atlassian.bitbucket.jenkins.internal.client.BitbucketClientFactoryImpl;
import com.atlassian.bitbucket.jenkins.internal.client.HttpRequestExecutor;
import com.atlassian.bitbucket.jenkins.internal.credentials.BitbucketCredentials;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@ThreadSafe
public class BitbucketClientFactoryProvider {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpRequestExecutor httpRequestExecutor;

    @Inject
    public BitbucketClientFactoryProvider(HttpRequestExecutor httpRequestExecutor) {
        this.httpRequestExecutor = httpRequestExecutor;
    }

    public BitbucketClientFactory getClient(String baseUrl, BitbucketCredentials credentials) {
        Objects.requireNonNull(baseUrl, "Bitbucket Server base url cannot be null.");
        Objects.requireNonNull(credentials, "Credentials can't be null. For no credentials use anonymous.");
        return new BitbucketClientFactoryImpl(baseUrl, credentials, objectMapper, this.httpRequestExecutor);
    }
}

