/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.Randomizer;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.Consumer;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.exception.InvalidTokenException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenFactory;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.oauth.OAuthMessage;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class ServiceProviderTokenFactoryImpl
implements ServiceProviderTokenFactory {
    private static final int ACCESS_TOKEN_SESSION_LENGTH_BYTES = 80;
    private static final int TOKEN_SECRET_LENGTH_BYTES = 80;
    private static final Logger log = Logger.getLogger(ServiceProviderTokenFactoryImpl.class.getName());
    private final Randomizer randomizer;

    @Inject
    public ServiceProviderTokenFactoryImpl(Randomizer randomizer) {
        this.randomizer = randomizer;
    }

    @Override
    public ServiceProviderToken generateAccessToken(ServiceProviderToken requestToken) {
        Objects.requireNonNull(requestToken, "requestToken");
        if (requestToken.isAccessToken()) {
            log.warning("Token is not a request token: " + String.valueOf(requestToken));
            throw new InvalidTokenException("Token is not a request token");
        }
        if (requestToken.getUser() == null || StringUtils.isBlank((CharSequence)requestToken.getVerifier())) {
            log.warning("Request token is not authorized: " + String.valueOf(requestToken));
            throw new InvalidTokenException("Request token is not authorized");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Request token '%s' was used to generate an access token", requestToken));
        }
        return ((ServiceProviderToken.ServiceProviderTokenBuilder)((ServiceProviderToken.ServiceProviderTokenBuilder)ServiceProviderToken.newAccessToken(UUID.randomUUID().toString()).callback(requestToken.getCallback()).consumer(requestToken.getConsumer())).creationTime(System.currentTimeMillis()).tokenSecret(this.randomizer.randomUrlSafeString(80))).authorizedBy(requestToken.getUser()).verifier(requestToken.getVerifier()).session(this.newSession(requestToken)).build();
    }

    @Override
    public ServiceProviderToken generateRequestToken(Consumer consumer) {
        Objects.requireNonNull(consumer, "consumer");
        return ((ServiceProviderToken.ServiceProviderTokenBuilder)((ServiceProviderToken.ServiceProviderTokenBuilder)ServiceProviderToken.newRequestToken(UUID.randomUUID().toString()).consumer(consumer)).creationTime(System.currentTimeMillis()).tokenSecret(this.randomizer.randomUrlSafeString(80))).build();
    }

    @Override
    public ServiceProviderToken generateRequestToken(Consumer consumer, URI callback) {
        Objects.requireNonNull(consumer, "consumer");
        Objects.requireNonNull(callback, "callback");
        return ((ServiceProviderToken.ServiceProviderTokenBuilder)((ServiceProviderToken.ServiceProviderTokenBuilder)ServiceProviderToken.newRequestToken(UUID.randomUUID().toString()).callback(callback).consumer(consumer)).creationTime(System.currentTimeMillis()).tokenSecret(this.randomizer.randomUrlSafeString(80))).build();
    }

    private ServiceProviderToken.Session newSession(ServiceProviderToken token) {
        ServiceProviderToken.Session.Builder builder = ServiceProviderToken.Session.newSession(this.randomizer.randomUrlSafeString(80));
        if (token.getSession() != null) {
            builder.creationTime(token.getSession().getCreationTime());
        }
        return builder.build();
    }

    public static final class RequestTokenGenerationRequest {
        private final Consumer consumer;
        private final URI callback;
        private final OAuthMessage message;

        private RequestTokenGenerationRequest(Builder builder) {
            this.consumer = builder.consumer;
            this.callback = builder.callback;
            this.message = builder.message;
        }

        public Consumer getConsumer() {
            return this.consumer;
        }

        public Optional<URI> getCallback() {
            return Optional.ofNullable(this.callback);
        }

        public Optional<OAuthMessage> getMessage() {
            return Optional.ofNullable(this.message);
        }

        public static final class Builder {
            private final Consumer consumer;
            private URI callback;
            private OAuthMessage message;

            public Builder(Consumer consumer) {
                this.consumer = Objects.requireNonNull(consumer, "consumer");
            }

            public Builder callback(URI callback) {
                this.callback = callback;
                return this;
            }

            public Builder message(OAuthMessage message) {
                this.message = message;
                return this;
            }

            public RequestTokenGenerationRequest build() {
                return new RequestTokenGenerationRequest(this);
            }
        }
    }
}

