/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.rest;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.OAuthConverter;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.Consumer;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.consumer.ServiceProviderConsumerStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderToken;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenFactory;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.token.ServiceProviderTokenStore;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.util.OAuthProblemUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.server.OAuthServlet;

@Singleton
public class RequestTokenRestEndpoint {
    public static final String INVALID_CALLBACK_ADVICE = "As per OAuth spec version 1.0 Revision A Section 6.1 <http://oauth.net/core/1.0a#auth_step1>, the oauth_callback parameter is required and must be either a valid, absolute URI using the http or https scheme, or 'oob' if the callback has been established out of band. The following invalid URI was supplied '%s'";
    public static final String REQUEST_TOKEN_PATH_END = "request-token";
    private static final Logger LOGGER = Logger.getLogger(RequestTokenRestEndpoint.class.getName());
    private OAuthValidator oAuthValidator;
    private ServiceProviderConsumerStore consumerStore;
    private ServiceProviderTokenFactory tokenFactory;
    private ServiceProviderTokenStore tokenStore;

    @Inject
    public RequestTokenRestEndpoint(OAuthValidator oAuthValidator, ServiceProviderConsumerStore consumerStore, ServiceProviderTokenFactory tokenFactory, ServiceProviderTokenStore tokenStore) {
        this.oAuthValidator = oAuthValidator;
        this.consumerStore = consumerStore;
        this.tokenFactory = tokenFactory;
        this.tokenStore = tokenStore;
    }

    public void handleRequestToken(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            OAuthMessage message = OAuthServlet.getMessage((HttpServletRequest)req, null);
            message.requireParameters(new String[]{"oauth_consumer_key"});
            Consumer consumer = this.consumerStore.get(message.getConsumerKey()).orElseThrow(() -> new OAuthProblemException("consumer_key_unknown"));
            try {
                this.oAuthValidator.validateMessage(message, new OAuthAccessor(OAuthConverter.toOAuthConsumer(consumer)));
            }
            catch (OAuthProblemException ope) {
                OAuthProblemUtils.logOAuthProblem(message, ope, LOGGER);
                throw ope;
            }
            URI callback = null;
            if (message.getParameter("oauth_callback") != null) {
                callback = this.callbackToUri(message.getParameter("oauth_callback"));
            }
            ServiceProviderToken token = this.tokenStore.put(callback == null ? this.tokenFactory.generateRequestToken(consumer) : this.tokenFactory.generateRequestToken(consumer, callback));
            resp.setContentType("text/plain");
            ServletOutputStream out = resp.getOutputStream();
            List<OAuth.Parameter> parameters = Arrays.asList(new OAuth.Parameter("oauth_token", token.getToken()), new OAuth.Parameter("oauth_token_secret", token.getTokenSecret()), new OAuth.Parameter("oauth_callback_confirmed", "true"));
            OAuth.formEncode(parameters, (OutputStream)out);
        }
        catch (Exception e) {
            OAuthServlet.handleException((HttpServletResponse)resp, (Exception)e, (String)req.getRequestURL().toString(), (boolean)true);
        }
    }

    @CheckForNull
    private URI callbackToUri(String callbackParameter) throws OAuthProblemException {
        URI callback;
        if (callbackParameter.equals("oob")) {
            return null;
        }
        try {
            callback = new URI(callbackParameter);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.SEVERE, "Unable to parse callback URI '%s'", callbackParameter);
            OAuthProblemException problem = new OAuthProblemException("parameter_rejected");
            problem.setParameter("oauth_parameters_rejected", (Object)"oauth_callback");
            problem.setParameter("oauth_problem_advice", (Object)String.format(INVALID_CALLBACK_ADVICE, callbackParameter));
            throw problem;
        }
        if (!ServiceProviderToken.isValidCallback(callback)) {
            LOGGER.log(Level.SEVERE, "Invalid callback URI '%s'", callbackParameter);
            OAuthProblemException problem = new OAuthProblemException("parameter_rejected");
            problem.setParameter("oauth_parameters_rejected", (Object)"oauth_callback");
            problem.setParameter("oauth_problem_advice", (Object)String.format(INVALID_CALLBACK_ADVICE, callbackParameter));
            throw problem;
        }
        return callback;
    }
}

