/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.AuthenticationFailedException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.OAuth1Authenticator;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.auth.TrustedUnderlyingSystemAuthorizerFilter;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.serviceprovider.exception.NoSuchUserException;
import com.atlassian.bitbucket.jenkins.internal.applink.oauth.util.OAuthProblemUtils;
import com.google.common.base.Preconditions;
import hudson.model.User;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;

public class OAuth1aRequestFilter
implements Filter {
    public static final String OAUTH_REQUEST_AUTHENTICATED_ATTRIBUTE_KEY = "bbdc_authenticated";
    private static final Logger log = Logger.getLogger(OAuth1aRequestFilter.class.getName());
    private final OAuth1Authenticator authenticator;
    private final TrustedUnderlyingSystemAuthorizerFilter authorizerFilter;

    @Inject
    public OAuth1aRequestFilter(OAuth1Authenticator authenticator, TrustedUnderlyingSystemAuthorizerFilter authorizerFilter) {
        this.authenticator = authenticator;
        this.authorizerFilter = authorizerFilter;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block7: {
            Boolean authed;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            Object authenticated = req.getAttribute(OAUTH_REQUEST_AUTHENTICATED_ATTRIBUTE_KEY);
            if (authenticated instanceof Boolean && (authed = (Boolean)authenticated).booleanValue()) {
                req.removeAttribute(OAUTH_REQUEST_AUTHENTICATED_ATTRIBUTE_KEY);
                chain.doFilter(request, response);
                return;
            }
            try {
                User user = this.authenticator.authenticate(req, resp);
                if (user != null) {
                    OAuthWWWAuthenticateAddingResponse oauthResp = new OAuthWWWAuthenticateAddingResponse(resp, OAuth1aRequestFilter.getBaseUrl(req));
                    this.authorizerFilter.authorize(user, req, (HttpServletResponse)oauthResp, chain);
                    OAuthProblemUtils.logOAuthRequest(req, "OAuth authentication successful. Request marked as OAuth.", log);
                } else {
                    chain.doFilter(request, response);
                }
            }
            catch (AuthenticationFailedException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof NoSuchUserException) {
                    String msg = String.format("User %s associated with the token %s not found in the system", exception.getUser(), exception.getTokenString());
                    OAuthServlet.handleException((HttpServletResponse)resp, (Exception)((Object)new OAuthProblemException(msg)), (String)OAuth1aRequestFilter.getBaseUrl(req));
                }
                if (cause instanceof OAuthProblemException) {
                    this.handleOAuthProblemException(req, resp, exception.getOAuthMessage(), (OAuthProblemException)cause);
                }
                if (!(cause instanceof Exception)) break block7;
                this.handleException(req, resp, exception.getOAuthMessage(), (Exception)cause);
            }
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    private static String getBaseUrl(HttpServletRequest request) {
        String scheme = request.getScheme() + "://";
        String serverName = request.getServerName();
        String serverPort = request.getServerPort() == 80 ? "" : ":" + request.getServerPort();
        String contextPath = request.getContextPath();
        return scheme + serverName + serverPort + contextPath;
    }

    private void handleException(HttpServletRequest request, HttpServletResponse response, OAuthMessage message, Exception e) {
        log.log(Level.SEVERE, "Failed to process OAuth message", e);
        this.sendError(request, response, 500, message);
    }

    private void handleOAuthProblemException(HttpServletRequest request, HttpServletResponse response, OAuthMessage message, OAuthProblemException ope) {
        OAuthProblemUtils.logOAuthProblem(message, ope, log);
        try {
            OAuthServlet.handleException((HttpServletResponse)response, (Exception)((Object)ope), (String)OAuth1aRequestFilter.getBaseUrl(request));
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failure reporting OAuth error to client", e);
        }
    }

    private void sendError(HttpServletRequest request, HttpServletResponse response, int status, OAuthMessage message) {
        response.setStatus(status);
        try {
            response.addHeader("WWW-Authenticate", message.getAuthorizationHeader(OAuth1aRequestFilter.getBaseUrl(request)));
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Failure reporting OAuth error to client", e);
        }
    }

    public static final class OAuthWWWAuthenticateAddingResponse
    extends HttpServletResponseWrapper {
        private final String baseUrl;

        public OAuthWWWAuthenticateAddingResponse(HttpServletResponse response, String baseUrl) {
            super(response);
            this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl, (Object)"baseUrl");
        }

        public void sendError(int sc, String msg) throws IOException {
            if (sc == 401) {
                this.addOAuthAuthenticateHeader();
            }
            super.sendError(sc, msg);
        }

        public void sendError(int sc) throws IOException {
            if (sc == 401) {
                this.addOAuthAuthenticateHeader();
            }
            super.sendError(sc);
        }

        public void setStatus(int sc, String sm) {
            if (sc == 401) {
                this.addOAuthAuthenticateHeader();
            }
            super.setStatus(sc, sm);
        }

        public void setStatus(int sc) {
            if (sc == 401) {
                this.addOAuthAuthenticateHeader();
            }
            super.setStatus(sc);
        }

        private void addOAuthAuthenticateHeader() {
            try {
                OAuthMessage message = new OAuthMessage(null, null, null);
                this.addHeader("WWW-Authenticate", message.getAuthorizationHeader(this.baseUrl));
            }
            catch (IOException e) {
                throw new RuntimeException("Somehow the OAuth.net library threw an IOException, even though it's not doing any IO operations", e);
            }
        }
    }
}

