/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.jenkins.internal.applink.oauth;

import com.atlassian.bitbucket.jenkins.internal.applink.oauth.Randomizer;
import com.google.common.annotations.VisibleForTesting;
import java.security.SecureRandom;

public class RandomizerImpl
implements Randomizer {
    @VisibleForTesting
    static final char[] ALPHA_NUM_CODEC = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();
    @VisibleForTesting
    static final char[] URL_SAFE_CODEC = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-_".toCharArray();
    private final SecureRandom random = new SecureRandom();

    private static String generateString(byte[] bytes, char[] allowedChars) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            chars[i] = allowedChars[(bytes[i] & 0xFF) % allowedChars.length];
        }
        return new String(chars);
    }

    @Override
    public String randomAlphanumericString(int length) {
        if (length == 0) {
            return "";
        }
        if (length < 0) {
            throw new IllegalArgumentException("Requested random string length " + length + " is less than 0.");
        }
        return RandomizerImpl.generateString(this.randomBytes(length), ALPHA_NUM_CODEC);
    }

    @Override
    public String randomUrlSafeString(int length) {
        if (length == 0) {
            return "";
        }
        if (length < 0) {
            throw new IllegalArgumentException("Requested random string length " + length + " is less than 0.");
        }
        return RandomizerImpl.generateString(this.randomBytes(length), URL_SAFE_CODEC);
    }

    private byte[] randomBytes(int length) {
        byte[] randomBytes = new byte[length];
        this.random.nextBytes(randomBytes);
        return randomBytes;
    }
}

