/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.json.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Bytes;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.inject.AbstractModule;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.Provides;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jclouds.date.DateService;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.JsonBall;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.json.Json;
import org.jclouds.json.SerializedNames;
import org.jclouds.json.internal.DeserializationConstructorAndReflectiveTypeAdapterFactory;
import org.jclouds.json.internal.EnumTypeAdapterThatReturnsFromValue;
import org.jclouds.json.internal.GsonWrapper;
import org.jclouds.json.internal.NamingStrategies;
import org.jclouds.json.internal.NullFilteringTypeAdapterFactories;
import org.jclouds.json.internal.NullHackJsonLiteralAdapter;
import org.jclouds.json.internal.OptionalTypeAdapterFactory;

public class GsonModule
extends AbstractModule {
    @Provides
    @Singleton
    final Gson provideGson(TypeAdapter<JsonBall> jsonAdapter, DateAdapter adapter, ByteListAdapter byteListAdapter, ByteArrayAdapter byteArrayAdapter, PropertiesAdapter propertiesAdapter, JsonAdapterBindings bindings, CredentialsAdapterFactory credentialsAdapterFactory, OptionalTypeAdapterFactory optional, NullFilteringTypeAdapterFactories.SetTypeAdapterFactory set, NullFilteringTypeAdapterFactories.ImmutableSetTypeAdapterFactory immutableSet, NullFilteringTypeAdapterFactories.MapTypeAdapterFactory map, NullFilteringTypeAdapterFactories.MultimapTypeAdapterFactory multimap, NullFilteringTypeAdapterFactories.IterableTypeAdapterFactory iterable, NullFilteringTypeAdapterFactories.CollectionTypeAdapterFactory collection, NullFilteringTypeAdapterFactories.ListTypeAdapterFactory list, NullFilteringTypeAdapterFactories.ImmutableListTypeAdapterFactory immutableList, NullFilteringTypeAdapterFactories.FluentIterableTypeAdapterFactory fluentIterable, NullFilteringTypeAdapterFactories.ImmutableMapTypeAdapterFactory immutableMap, DefaultExclusionStrategy exclusionStrategy) {
        NamingStrategies.AnnotationOrNameFieldNamingStrategy serializationPolicy = new NamingStrategies.AnnotationOrNameFieldNamingStrategy((Iterable<? extends NamingStrategies.NameExtractor<?>>)ImmutableSet.of((Object)new NamingStrategies.ExtractSerializedName(), (Object)new NamingStrategies.ExtractNamed()));
        GsonBuilder builder = new GsonBuilder().setFieldNamingStrategy((FieldNamingStrategy)serializationPolicy).setExclusionStrategies(new ExclusionStrategy[]{exclusionStrategy});
        builder.registerTypeAdapter(Properties.class, (Object)propertiesAdapter.nullSafe());
        builder.registerTypeAdapter(Date.class, (Object)adapter.nullSafe());
        builder.registerTypeAdapter(byte[].class, (Object)byteArrayAdapter.nullSafe());
        builder.registerTypeAdapter(JsonBall.class, (Object)jsonAdapter.nullSafe());
        builder.registerTypeAdapter(File.class, (Object)new FileTypeAdapter());
        builder.registerTypeAdapterFactory((TypeAdapterFactory)credentialsAdapterFactory);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)optional);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)iterable);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)collection);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)list);
        builder.registerTypeAdapter(new TypeToken<List<Byte>>(){}.getType(), (Object)byteListAdapter.nullSafe());
        builder.registerTypeAdapterFactory((TypeAdapterFactory)immutableList);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)set);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)immutableSet);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)map);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)multimap);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)fluentIterable);
        builder.registerTypeAdapterFactory((TypeAdapterFactory)immutableMap);
        NamingStrategies.AnnotationConstructorNamingStrategy deserializationPolicy = new NamingStrategies.AnnotationConstructorNamingStrategy((Collection<? extends Class<? extends Annotation>>)ImmutableSet.of(ConstructorProperties.class, SerializedNames.class, Inject.class), (Iterable<? extends NamingStrategies.NameExtractor<?>>)ImmutableSet.of((Object)new NamingStrategies.ExtractNamed()));
        builder.registerTypeAdapterFactory((TypeAdapterFactory)new DeserializationConstructorAndReflectiveTypeAdapterFactory(new ConstructorConstructor((Map)ImmutableMap.of(), false, (List)ImmutableList.of()), serializationPolicy, Excluder.DEFAULT, deserializationPolicy));
        builder.registerTypeHierarchyAdapter(Enum.class, new EnumTypeAdapterThatReturnsFromValue());
        for (Map.Entry<Type, Object> binding : bindings.getBindings().entrySet()) {
            builder.registerTypeAdapter(binding.getKey(), binding.getValue());
        }
        for (TypeAdapterFactory factory : bindings.getFactories()) {
            builder.registerTypeAdapterFactory(factory);
        }
        return builder.create();
    }

    @Provides
    @Singleton
    protected final TypeAdapter<JsonBall> provideJsonBallAdapter(NullHackJsonBallAdapter in) {
        return in;
    }

    protected void configure() {
        this.bind(Json.class).to(GsonWrapper.class);
    }

    @Singleton
    public static class JsonAdapterBindings {
        private final Map<Type, Object> bindings = Maps.newHashMap();
        private final Set<TypeAdapterFactory> factories = Sets.newHashSet();

        @Inject(optional=true)
        public void setBindings(Map<Type, Object> bindings) {
            this.bindings.putAll(bindings);
        }

        @Inject(optional=true)
        public void setFactories(Set<TypeAdapterFactory> factories) {
            this.factories.addAll(factories);
        }

        public Map<Type, Object> getBindings() {
            return this.bindings;
        }

        public Set<TypeAdapterFactory> getFactories() {
            return this.factories;
        }
    }

    public static class CredentialsAdapterFactory
    extends TypeAdapter<Credentials>
    implements TypeAdapterFactory {
        public void write(JsonWriter out, Credentials credentials) throws IOException {
            out.beginObject();
            if (credentials instanceof LoginCredentials) {
                LoginCredentials login = (LoginCredentials)credentials;
                out.name("user");
                out.value(login.getUser());
                out.name("password");
                out.value((String)login.getOptionalPassword().orNull());
                out.name("privateKey");
                out.value((String)login.getOptionalPrivateKey().orNull());
                if (login.shouldAuthenticateSudo()) {
                    out.name("authenticateSudo");
                    out.value(login.shouldAuthenticateSudo());
                }
            } else {
                out.name("identity");
                out.value(credentials.identity);
                out.name("credential");
                out.value(credentials.credential);
            }
            out.endObject();
        }

        public Credentials read(JsonReader in) throws IOException {
            LoginCredentials.Builder builder = LoginCredentials.builder();
            String identity = null;
            String credential = null;
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                if (name.equals("identity")) {
                    identity = in.nextString();
                    continue;
                }
                if (name.equals("credential")) {
                    credential = in.nextString();
                    continue;
                }
                if (name.equals("user")) {
                    builder.user(in.nextString());
                    continue;
                }
                if (name.equals("password")) {
                    builder.password(in.nextString());
                    continue;
                }
                if (name.equals("privateKey")) {
                    builder.privateKey(in.nextString());
                    continue;
                }
                if (name.equals("authenticateSudo")) {
                    builder.authenticateSudo(in.nextBoolean());
                    continue;
                }
                in.skipValue();
            }
            in.endObject();
            LoginCredentials result = builder.build();
            return result != null ? result : new Credentials(identity, credential);
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Credentials.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return this;
        }
    }

    private static class FileTypeAdapter
    extends TypeAdapter<File> {
        private FileTypeAdapter() {
        }

        public void write(JsonWriter out, File file) throws IOException {
            if (file == null) {
                out.nullValue();
            } else {
                out.value(file.getPath());
            }
        }

        public File read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return new File(in.nextString());
        }
    }

    @Singleton
    public static class LongDateAdapter
    extends DateAdapter {
        public void write(JsonWriter writer, Date value) throws IOException {
            writer.value(value.getTime());
        }

        public Date read(JsonReader reader) throws IOException {
            long toParse = reader.nextLong();
            if (toParse == -1L) {
                return null;
            }
            return new Date(toParse);
        }
    }

    @Singleton
    public static class CDateAdapter
    extends DateAdapter {
        private final DateService dateService;

        @Inject
        public CDateAdapter(DateService dateService) {
            this.dateService = dateService;
        }

        public void write(JsonWriter writer, Date value) throws IOException {
            writer.value(this.dateService.cDateFormat(value));
        }

        public Date read(JsonReader reader) throws IOException {
            return this.dateService.cDateParse(reader.nextString());
        }
    }

    @Singleton
    public static class PropertiesAdapter
    extends TypeAdapter<Properties> {
        private final Provider<Gson> gson;
        private final TypeToken<Map<String, String>> mapType = new TypeToken<Map<String, String>>(){};

        @Inject
        public PropertiesAdapter(Provider<Gson> gson) {
            this.gson = gson;
        }

        public void write(JsonWriter out, Properties value) throws IOException {
            ImmutableMap.Builder srcMap = ImmutableMap.builder();
            Enumeration<?> propNames = value.propertyNames();
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                srcMap.put((Object)propName, (Object)value.getProperty(propName));
            }
            ((Gson)this.gson.get()).getAdapter(this.mapType).write(out, (Object)srcMap.build());
        }

        public Properties read(JsonReader in) throws IOException {
            Properties props = new Properties();
            in.beginObject();
            while (in.hasNext()) {
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(in);
                props.setProperty(in.nextString(), in.nextString());
            }
            in.endObject();
            return props;
        }
    }

    @Singleton
    public static class Iso8601DateAdapter
    extends DateAdapter {
        private final DateService dateService;

        @Inject
        public Iso8601DateAdapter(DateService dateService) {
            this.dateService = dateService;
        }

        public void write(JsonWriter writer, Date value) throws IOException {
            writer.value(this.dateService.iso8601DateFormat(value));
        }

        public Date read(JsonReader reader) throws IOException {
            return this.parseDate(reader.nextString());
        }

        protected Date parseDate(String toParse) {
            try {
                return this.dateService.iso8601DateParse(toParse);
            }
            catch (RuntimeException e) {
                return this.dateService.iso8601SecondsDateParse(toParse);
            }
        }
    }

    @Singleton
    public static class HexByteArrayAdapter
    extends ByteArrayAdapter {
        public void write(JsonWriter writer, byte[] value) throws IOException {
            writer.value(BaseEncoding.base16().lowerCase().encode(value));
        }

        public byte[] read(JsonReader reader) throws IOException {
            return BaseEncoding.base16().lowerCase().decode((CharSequence)reader.nextString());
        }
    }

    @Singleton
    public static class HexByteListAdapter
    extends ByteListAdapter {
        public void write(JsonWriter writer, List<Byte> value) throws IOException {
            writer.value(BaseEncoding.base16().lowerCase().encode(Bytes.toArray(value)));
        }

        public List<Byte> read(JsonReader reader) throws IOException {
            return Bytes.asList((byte[])BaseEncoding.base16().lowerCase().decode((CharSequence)reader.nextString()));
        }
    }

    @ImplementedBy(value=HexByteArrayAdapter.class)
    public static abstract class ByteArrayAdapter
    extends TypeAdapter<byte[]> {
    }

    @ImplementedBy(value=HexByteListAdapter.class)
    public static abstract class ByteListAdapter
    extends TypeAdapter<List<Byte>> {
    }

    public static class NullHackJsonBallAdapter
    extends NullHackJsonLiteralAdapter<JsonBall> {
        @Override
        protected JsonBall createJsonLiteralFromRawJson(String json) {
            return new JsonBall(json);
        }
    }

    @ImplementedBy(value=CDateAdapter.class)
    public static abstract class DateAdapter
    extends TypeAdapter<Date> {
    }

    public static class NoExclusions
    implements DefaultExclusionStrategy {
        public boolean shouldSkipField(FieldAttributes f) {
            return false;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }

    @ImplementedBy(value=NoExclusions.class)
    public static interface DefaultExclusionStrategy
    extends ExclusionStrategy {
    }
}

