/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.io;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.BaseEncoding;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jclouds.date.DateCodec;
import org.jclouds.date.DateCodecFactory;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.logging.Logger;

@ImplementedBy(value=DefaultContentMetadataCodec.class)
public interface ContentMetadataCodec {
    public Multimap<String, String> toHeaders(ContentMetadata var1);

    public void fromHeaders(MutableContentMetadata var1, Multimap<String, String> var2);

    public Date parseExpires(String var1);

    public static class DefaultContentMetadataCodec
    implements ContentMetadataCodec {
        @Resource
        protected Logger logger = Logger.NULL;
        private final DateCodec httpExpiresDateCodec;
        private final List<DateCodec> httpExpiresDateDecoders;

        @Inject
        public DefaultContentMetadataCodec(DateCodecFactory dateCodecs) {
            this.httpExpiresDateCodec = dateCodecs.rfc1123();
            this.httpExpiresDateDecoders = ImmutableList.of((Object)dateCodecs.rfc1123(), (Object)dateCodecs.asctime());
        }

        protected DateCodec getExpiresDateCodec() {
            return this.httpExpiresDateCodec;
        }

        protected List<DateCodec> getExpiresDateDecoders() {
            return this.httpExpiresDateDecoders;
        }

        @Override
        public Multimap<String, String> toHeaders(ContentMetadata md) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            if (md.getCacheControl() != null) {
                builder.put((Object)"Cache-Control", (Object)md.getCacheControl());
            }
            if (md.getContentType() != null) {
                builder.put((Object)"Content-Type", (Object)md.getContentType());
            }
            if (md.getContentDisposition() != null) {
                builder.put((Object)"Content-Disposition", (Object)md.getContentDisposition());
            }
            if (md.getContentEncoding() != null) {
                builder.put((Object)"Content-Encoding", (Object)md.getContentEncoding());
            }
            if (md.getContentLanguage() != null) {
                builder.put((Object)"Content-Language", (Object)md.getContentLanguage());
            }
            if (md.getContentLength() != null) {
                builder.put((Object)"Content-Length", (Object)(md.getContentLength() + ""));
            }
            if (md.getContentMD5() != null) {
                builder.put((Object)"Content-MD5", (Object)BaseEncoding.base64().encode(md.getContentMD5()));
            }
            if (md.getExpires() != null) {
                builder.put((Object)"Expires", (Object)this.getExpiresDateCodec().toString(md.getExpires()));
            }
            return builder.build();
        }

        @Override
        public void fromHeaders(MutableContentMetadata contentMetadata, Multimap<String, String> headers) {
            boolean chunked = Iterables.any((Iterable)headers.entries(), (Predicate)new Predicate<Map.Entry<String, String>>(){

                public boolean apply(Map.Entry<String, String> input) {
                    return "Transfer-Encoding".equalsIgnoreCase(input.getKey()) && "chunked".equalsIgnoreCase(input.getValue());
                }
            });
            for (Map.Entry header : headers.entries()) {
                if ("Cache-Control".equalsIgnoreCase((String)header.getKey())) {
                    contentMetadata.setCacheControl((String)header.getValue());
                    continue;
                }
                if (!chunked && "Content-Length".equalsIgnoreCase((String)header.getKey())) {
                    contentMetadata.setContentLength(Long.valueOf((String)header.getValue()));
                    continue;
                }
                if ("Content-MD5".equalsIgnoreCase((String)header.getKey())) {
                    contentMetadata.setContentMD5(BaseEncoding.base64().decode((CharSequence)header.getValue()));
                    continue;
                }
                if ("Content-Type".equalsIgnoreCase((String)header.getKey())) {
                    contentMetadata.setContentType((String)header.getValue());
                    continue;
                }
                if ("Content-Disposition".equalsIgnoreCase((String)header.getKey())) {
                    contentMetadata.setContentDisposition((String)header.getValue());
                    continue;
                }
                if ("Content-Encoding".equalsIgnoreCase((String)header.getKey())) {
                    contentMetadata.setContentEncoding((String)header.getValue());
                    continue;
                }
                if ("Content-Language".equalsIgnoreCase((String)header.getKey())) {
                    contentMetadata.setContentLanguage((String)header.getValue());
                    continue;
                }
                if (!"Expires".equalsIgnoreCase((String)header.getKey())) continue;
                contentMetadata.setExpires(this.parseExpires((String)header.getValue()));
            }
        }

        @Override
        public Date parseExpires(String expires) {
            if (expires == null) {
                return null;
            }
            for (DateCodec decoder : this.getExpiresDateDecoders()) {
                try {
                    return decoder.toDate(expires);
                }
                catch (IllegalArgumentException ex) {
                    this.logger.trace("Expires header (%s) is not in the expected %s format", expires, decoder);
                }
            }
            this.logger.debug("Invalid Expires header (%s); should be in RFC-1123 format; treating as already expired", expires);
            return new Date(0L);
        }
    }
}

