/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.handlers;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.http.handlers.CloseContentAndSetExceptionErrorHandler;

@Singleton
public class DelegatingErrorHandler
implements HttpErrorHandler {
    @Inject(optional=true)
    @Redirection
    @VisibleForTesting
    HttpErrorHandler redirectionHandler;
    @Inject(optional=true)
    @ClientError
    @VisibleForTesting
    HttpErrorHandler clientErrorHandler;
    @Inject(optional=true)
    @ServerError
    @VisibleForTesting
    HttpErrorHandler serverErrorHandler;

    @Inject
    DelegatingErrorHandler() {
        this.clientErrorHandler = this.redirectionHandler = new CloseContentAndSetExceptionErrorHandler();
        this.serverErrorHandler = this.redirectionHandler;
    }

    @Override
    public void handleError(HttpCommand command, HttpResponse response) {
        int statusCode = response.getStatusCode();
        if (statusCode >= 300 && statusCode < 400) {
            this.getRedirectionHandler().handleError(command, response);
        } else if (statusCode >= 400 && statusCode < 500) {
            this.getClientErrorHandler().handleError(command, response);
        } else if (statusCode >= 500) {
            this.getServerErrorHandler().handleError(command, response);
        }
    }

    public HttpErrorHandler getRedirectionHandler() {
        return this.redirectionHandler;
    }

    public HttpErrorHandler getClientErrorHandler() {
        return this.clientErrorHandler;
    }

    public HttpErrorHandler getServerErrorHandler() {
        return this.serverErrorHandler;
    }
}

