/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import com.google.common.base.Function;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;
import org.jclouds.util.Strings2;

@Singleton
public class ReturnStringIf2xx
implements Function<HttpResponse, String> {
    public String apply(HttpResponse from) {
        if (from.getPayload() == null) {
            return null;
        }
        try {
            if (from.getStatusCode() >= 200) {
                InputStream payload = from.getPayload().getInput();
                String toReturn = null;
                try {
                    toReturn = Strings2.toStringAndClose(payload);
                }
                catch (IOException e) {
                    throw new HttpException(String.format("Couldn't receive response %1$s, payload: %2$s ", from, toReturn), e);
                }
                String string = toReturn;
                return string;
            }
            throw new HttpException(String.format("Unhandled status code  - %1$s", from));
        }
        finally {
            HttpUtils.releasePayload(from);
        }
    }
}

