/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.functions;

import com.google.common.base.Function;
import jakarta.inject.Singleton;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpUtils;

@Singleton
public class ParseETagHeader
implements Function<HttpResponse, String> {
    public String apply(HttpResponse from) {
        HttpUtils.releasePayload(from);
        String eTag = from.getFirstHeaderOrNull("ETag");
        if (eTag == null) {
            eTag = from.getFirstHeaderOrNull("Etag");
        }
        if (eTag != null) {
            return eTag;
        }
        throw new HttpException("did not receive ETag");
    }
}

