/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;

public class ValueOfConfigurationKeyOrNull
implements Function<String, String> {
    private final Injector injector;

    @Inject
    private ValueOfConfigurationKeyOrNull(Injector injector) {
        this.injector = (Injector)Preconditions.checkNotNull((Object)injector, (Object)"injector");
    }

    public String apply(String configurationKey) {
        Preconditions.checkNotNull((Object)configurationKey, (Object)"configurationKey");
        try {
            return (String)this.injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)configurationKey)));
        }
        catch (ConfigurationException e) {
            return null;
        }
    }
}

