/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.functions;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.rest.binders.BindToStringPayload;
import org.jclouds.s3.Bucket;

@Singleton
public class BindRegionToXmlPayload
extends BindToStringPayload {
    @Resource
    protected Logger logger = Logger.NULL;
    private final Supplier<String> defaultRegionForEndpointSupplier;
    private final Supplier<String> defaultRegionForServiceSupplier;
    private final Supplier<Set<String>> regionsSupplier;

    @Inject
    public BindRegionToXmlPayload(@Region Supplier<String> defaultRegionForEndpointSupplier, @Bucket Supplier<String> defaultRegionForServiceSupplier, @Region Supplier<Set<String>> regionsSupplier) {
        this.defaultRegionForEndpointSupplier = defaultRegionForEndpointSupplier;
        this.defaultRegionForServiceSupplier = defaultRegionForServiceSupplier;
        this.regionsSupplier = (Supplier)Preconditions.checkNotNull(regionsSupplier, (Object)"regions");
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String defaultRegionForEndpoint = (String)this.defaultRegionForEndpointSupplier.get();
        if (defaultRegionForEndpoint == null) {
            return request;
        }
        input = input == null ? defaultRegionForEndpoint : input;
        Preconditions.checkArgument((boolean)(input instanceof String), (Object)"this binder is only valid for Region!");
        String constraint = (String)input;
        String value = null;
        String defaultRegionForService = (String)this.defaultRegionForServiceSupplier.get();
        Set regions = (Set)this.regionsSupplier.get();
        if (defaultRegionForService == null && constraint == null || defaultRegionForService != null && defaultRegionForService.equals(constraint)) {
            return request;
        }
        if (regions.contains(constraint)) {
            value = constraint;
        } else {
            this.logger.warn("region %s not in %s ", new Object[]{constraint, regions});
            value = constraint;
        }
        String payload = String.format("<CreateBucketConfiguration><LocationConstraint>%s</LocationConstraint></CreateBucketConfiguration>", value);
        request = super.bindToRequest(request, (Object)payload);
        request.getPayload().getContentMetadata().setContentType("text/xml");
        return request;
    }
}

