/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.List;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.functions.BlobToHttpGetOptions;
import org.jclouds.blobstore.util.BlobStoreUtils;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.options.GetOptions;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.jclouds.s3.S3Client;
import org.jclouds.s3.blobstore.functions.BlobToObject;
import org.jclouds.s3.domain.S3Object;
import org.jclouds.s3.filters.RequestAuthorizeSignature;
import org.jclouds.s3.options.PutObjectOptions;

@Singleton
public class S3BlobRequestSigner<T extends S3Client>
implements BlobRequestSigner {
    private static final int DEFAULT_EXPIRY_SECONDS = 900;
    private final RequestAuthorizeSignature authSigner;
    protected final RestAnnotationProcessor processor;
    protected final BlobToObject blobToObject;
    protected final BlobToHttpGetOptions blob2HttpGetOptions;
    protected final Invokable<?, ?> getMethod;
    protected final Invokable<?, ?> deleteMethod;
    protected final Invokable<?, ?> createMethod;

    @Inject
    public S3BlobRequestSigner(RestAnnotationProcessor processor, BlobToObject blobToObject, BlobToHttpGetOptions blob2HttpGetOptions, Class<T> interfaceClass, RequestAuthorizeSignature authSigner) throws SecurityException, NoSuchMethodException {
        this.processor = (RestAnnotationProcessor)Preconditions.checkNotNull((Object)processor, (Object)"processor");
        this.blobToObject = (BlobToObject)Preconditions.checkNotNull((Object)blobToObject, (Object)"blobToObject");
        this.blob2HttpGetOptions = (BlobToHttpGetOptions)Preconditions.checkNotNull((Object)blob2HttpGetOptions, (Object)"blob2HttpGetOptions");
        this.getMethod = Reflection2.method(interfaceClass, (String)"getObject", (Class[])new Class[]{String.class, String.class, GetOptions[].class});
        this.deleteMethod = Reflection2.method(interfaceClass, (String)"deleteObject", (Class[])new Class[]{String.class, String.class});
        this.createMethod = Reflection2.method(interfaceClass, (String)"putObject", (Class[])new Class[]{String.class, S3Object.class, PutObjectOptions[].class});
        this.authSigner = authSigner;
    }

    public HttpRequest signGetBlob(String container, String name) {
        return this.signGetBlob(container, name, 900L);
    }

    public HttpRequest signGetBlob(String container, String name, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        GeneratedHttpRequest request = this.processor.apply(Invocation.create(this.getMethod, (List)ImmutableList.of((Object)container, (Object)name)));
        return BlobStoreUtils.cleanRequest((HttpRequest)this.authSigner.signForTemporaryAccess((HttpRequest)request, timeInSeconds));
    }

    public HttpRequest signPutBlob(String container, Blob blob) {
        return this.signPutBlob(container, blob, 900L);
    }

    public HttpRequest signPutBlob(String container, Blob blob, long timeInSeconds) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)blob, (Object)"blob");
        GeneratedHttpRequest request = this.processor.apply(Invocation.create(this.createMethod, (List)ImmutableList.of((Object)container, (Object)this.blobToObject.apply(blob))));
        return BlobStoreUtils.cleanRequest((HttpRequest)this.authSigner.signForTemporaryAccess((HttpRequest)request, timeInSeconds));
    }

    public HttpRequest signGetBlob(String container, String name, org.jclouds.blobstore.options.GetOptions options) {
        Preconditions.checkNotNull((Object)container, (Object)"container");
        Preconditions.checkNotNull((Object)name, (Object)"name");
        return BlobStoreUtils.cleanRequest((HttpRequest)this.processor.apply(Invocation.create(this.getMethod, (List)ImmutableList.of((Object)container, (Object)name, (Object)this.blob2HttpGetOptions.apply((org.jclouds.blobstore.options.GetOptions)Preconditions.checkNotNull((Object)options, (Object)"options"))))));
    }
}

