/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.armorcode.config;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.scheduler.CronTab;
import hudson.util.FormValidation;
import java.net.HttpURLConnection;
import java.net.URL;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension
public class ArmorCodeGlobalConfig
extends GlobalConfiguration {
    private String baseUrl = "https://app.armorcode.com";
    private boolean monitorBuilds = false;
    private String jobFilter = "";
    private String includeJobsPattern = ".*";
    private String excludeJobsPattern = "";
    private String cronExpression = "H H * * *";

    public ArmorCodeGlobalConfig() {
        this.load();
        if (!this.jobFilter.isEmpty() && this.includeJobsPattern.equals(".*") && this.excludeJobsPattern.isEmpty()) {
            this.convertLegacyJobFilter();
        }
    }

    private void convertLegacyJobFilter() {
        String[] patterns = this.jobFilter.split(",");
        StringBuilder includes = new StringBuilder();
        StringBuilder excludes = new StringBuilder();
        for (String pattern : patterns) {
            if ((pattern = pattern.trim()).startsWith("!")) {
                if (excludes.length() > 0) {
                    excludes.append("|");
                }
                excludes.append(pattern.substring(1));
                continue;
            }
            if (includes.length() > 0) {
                includes.append("|");
            }
            includes.append(pattern);
        }
        if (includes.length() > 0) {
            this.includeJobsPattern = includes.toString();
        }
        if (excludes.length() > 0) {
            this.excludeJobsPattern = excludes.toString();
        }
        this.jobFilter = "";
        this.save();
    }

    public static ArmorCodeGlobalConfig get() {
        return (ArmorCodeGlobalConfig)((Object)GlobalConfiguration.all().get(ArmorCodeGlobalConfig.class));
    }

    public String getDisplayName() {
        return "ArmorCode Configuration";
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @DataBoundSetter
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        this.save();
    }

    public boolean isMonitorBuilds() {
        return this.monitorBuilds;
    }

    @DataBoundSetter
    public void setMonitorBuilds(boolean monitorBuilds) {
        this.monitorBuilds = monitorBuilds;
        this.save();
    }

    public String getJobFilter() {
        return this.jobFilter;
    }

    @DataBoundSetter
    public void setJobFilter(String jobFilter) {
        this.jobFilter = jobFilter;
        this.save();
    }

    public String getIncludeJobsPattern() {
        return this.includeJobsPattern;
    }

    @DataBoundSetter
    public void setIncludeJobsPattern(String pattern) {
        this.includeJobsPattern = pattern;
        this.save();
    }

    public String getExcludeJobsPattern() {
        return this.excludeJobsPattern;
    }

    @DataBoundSetter
    public void setExcludeJobsPattern(String pattern) {
        this.excludeJobsPattern = pattern;
        this.save();
    }

    public boolean shouldMonitorJob(String jobName) {
        if (!this.excludeJobsPattern.isEmpty() && jobName.matches(this.excludeJobsPattern)) {
            return false;
        }
        return jobName.matches(this.includeJobsPattern);
    }

    @POST
    public FormValidation doCheckBaseUrl(@QueryParameter(value="baseUrl") String baseUrl) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (baseUrl.isEmpty()) {
            return FormValidation.error((String)"Base URL must not be empty");
        }
        if (!baseUrl.startsWith("https://")) {
            return FormValidation.error((String)"Base URL must start with https://");
        }
        return FormValidation.ok();
    }

    @POST
    public FormValidation doTestConnection(@QueryParameter String baseUrl) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (baseUrl.isEmpty()) {
            return FormValidation.error((String)"Base URL is required");
        }
        try {
            URL url = new URL(baseUrl + "/client/ping");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                return FormValidation.ok((String)"Connection successful!");
            }
            return FormValidation.error((String)("Connection failed with status: " + responseCode));
        }
        catch (Exception e) {
            return FormValidation.error((String)("Connection failed: " + e.getMessage()));
        }
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    @DataBoundSetter
    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression == null || cronExpression.isBlank() ? "H H * * *" : cronExpression;
        this.save();
    }

    @POST
    public FormValidation doCheckCronExpression(@QueryParameter String value) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        if (value == null || value.isBlank()) {
            return FormValidation.error((String)"Cron Expression must not be empty");
        }
        try {
            new CronTab(value);
            if (this.isTooFrequent(value)) {
                return FormValidation.error((String)"Cron expression must not run more frequently than once per hour");
            }
            return FormValidation.ok();
        }
        catch (ANTLRException e) {
            return FormValidation.error((String)("Invalid Cron Expression: " + e.getMessage()));
        }
    }

    private boolean isTooFrequent(String cronExpression) {
        int step;
        String[] parts = cronExpression.trim().split("\\s+");
        if (parts.length < 5) {
            return false;
        }
        String minutes = parts[0];
        if (minutes.matches("\\*/\\d+") && (step = Integer.parseInt(minutes.substring(2))) < 60) {
            return true;
        }
        if (minutes.contains(",") || minutes.contains("-") || minutes.equals("*")) {
            return true;
        }
        if (minutes.matches("H/\\d+")) {
            step = Integer.parseInt(minutes.substring(2));
            return step < 60;
        }
        return false;
    }
}

