/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.utils;

import com.hcl.appscan.sdk.CoreConstants;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.http.HttpClient;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONArtifact;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class ServiceUtil
implements CoreConstants {
    public static void getSAClientUtil(File destination) throws IOException {
        ServiceUtil.getSAClientUtil(destination, Proxy.NO_PROXY);
    }

    public static void getSAClientUtil(File destination, Proxy proxy) throws IOException {
        ServiceUtil.getSAClientUtil(destination, Proxy.NO_PROXY, "", "");
    }

    public static void getSAClientUtil(File destination, Proxy proxy, String serverURL, String acceptInvalidCerts) throws IOException {
        String request_url = ServiceUtil.requiredServerURL(serverURL);
        request_url = request_url + String.format("/api/v4/Tools/SAClientUtil?os=%s", SystemUtil.getOS());
        HttpClient client = new HttpClient(proxy, acceptInvalidCerts.equals("true"));
        HttpResponse response = client.get(request_url, null, null);
        if (response.getResponseCode() == 200 || response.getResponseCode() == 201) {
            if (!destination.getParentFile().isDirectory()) {
                destination.getParentFile().mkdirs();
            }
        } else {
            throw new IOException(response.getResponseBodyAsString());
        }
        response.getResponseBodyAsFile(destination);
    }

    private static String requiredServerURL(String serverURL) {
        String request_url = SystemUtil.getDefaultServer();
        if (serverURL != null && !serverURL.isEmpty()) {
            request_url = serverURL;
        }
        return request_url;
    }

    public static String getSAClientVersion() throws IOException {
        return ServiceUtil.getSAClientVersion(Proxy.NO_PROXY);
    }

    public static String getSAClientVersion(Proxy proxy) throws IOException {
        return ServiceUtil.getSAClientVersion(proxy, "");
    }

    public static String getSAClientVersion(Proxy proxy, String serverURL) throws IOException {
        return ServiceUtil.getSAClientVersion(Proxy.NO_PROXY, serverURL, false);
    }

    public static String getSAClientVersion(Proxy proxy, String serverURL, boolean acceptInvalidCerts) throws IOException {
        String request_url = ServiceUtil.requiredServerURL(serverURL);
        HttpClient client = new HttpClient(proxy, acceptInvalidCerts);
        HttpResponse response = client.get(request_url = request_url + String.format("/api/v4/Tools/SAClientUtil?os=%s&meta=%s", SystemUtil.getOS(), "true"), null, null);
        if (response.getResponseCode() == 200 || response.getResponseCode() == 201) {
            try {
                JSONArtifact responseContent = response.getResponseBodyAsJSON();
                if (responseContent != null) {
                    JSONObject object = (JSONObject)responseContent;
                    return object.getString("VersionNumber");
                }
            }
            catch (JSONException e) {
                return "0";
            }
        }
        return null;
    }

    public static boolean isValidUrl(String url, IAuthenticationProvider provider) {
        return ServiceUtil.isValidUrl(url, provider, Proxy.NO_PROXY);
    }

    public static boolean isValidUrl(String url, IAuthenticationProvider provider, Proxy proxy) {
        String request_url = provider.getServer() + "/api/v4/Scans/IsValidUrl";
        try {
            JSONArtifact responseContent;
            JSONObject body = new JSONObject();
            body.put("Url", (Object)url);
            HttpClient client = new HttpClient(proxy, provider.getacceptInvalidCerts());
            Map<String, String> requestHeaders = provider.getAuthorizationHeader(false);
            requestHeaders.put("Content-Type", "application/json");
            HttpResponse response = client.post(request_url, requestHeaders, body.toString());
            if (response.isSuccess() && (responseContent = response.getResponseBodyAsJSON()) != null) {
                JSONObject object = (JSONObject)responseContent;
                return object.getBoolean("IsValid");
            }
        }
        catch (IOException | JSONException throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasScaEntitlement(IAuthenticationProvider provider) {
        return ServiceUtil.hasEntitlement("ScaAnalyzer", provider);
    }

    public static boolean hasSastEntitlement(IAuthenticationProvider provider) {
        return ServiceUtil.hasEntitlement("StaticAnalyzer", provider);
    }

    public static boolean hasDastEntitlement(IAuthenticationProvider provider) {
        return ServiceUtil.hasEntitlement("DynamicAnalyzer", provider);
    }

    private static boolean hasEntitlement(String scanType, IAuthenticationProvider provider) {
        if (provider.isTokenExpired()) {
            return true;
        }
        String request_url = provider.getServer() + "/api/v4/Account/TenantInfo";
        try {
            JSONArtifact responseContent;
            HttpClient client = new HttpClient(provider.getProxy(), provider.getacceptInvalidCerts());
            Map<String, String> requestHeaders = provider.getAuthorizationHeader(false);
            requestHeaders.put("Content-Type", "application/json");
            requestHeaders.put("accept", "application/json");
            HttpResponse response = client.get(request_url, requestHeaders, null);
            if (response.isSuccess() && (responseContent = response.getResponseBodyAsJSON()) != null) {
                JSONObject object = (JSONObject)responseContent;
                String activeTechnologies = object.getString("ActiveTechnologies");
                return activeTechnologies.contains(scanType);
            }
        }
        catch (IOException | JSONException throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean isValidScanId(String scanId, String applicationId, String type, IAuthenticationProvider provider) throws IOException {
        if (provider.isTokenExpired()) {
            return true;
        }
        String request_url = provider.getServer() + "/api/v4/Scans";
        request_url = request_url + "?$filter=Id%20eq%20" + scanId + "&%24select=AppId%2C%20Technology";
        Map<String, String> request_headers = provider.getAuthorizationHeader(true);
        HttpClient client = new HttpClient(provider.getProxy(), provider.getacceptInvalidCerts());
        try {
            HttpResponse response = client.get(request_url, request_headers, null);
            if (response.isSuccess()) {
                JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
                JSONArray array = (JSONArray)obj.get("Items");
                if (array.isEmpty()) {
                    return false;
                }
                JSONObject body = array.getJSONObject(0);
                String appId = body.getString("AppId");
                String technologyName = body.getString("Technology");
                return appId.equals(applicationId) && technologyName.equals(ServiceUtil.updatedScanType(type));
            }
        }
        catch (JSONException e) {
            Logger.getLogger(ServiceUtil.class.getName()).log(Level.SEVERE, null, e);
        }
        return false;
    }

    public static String updatedScanType(String type) {
        switch (type) {
            case "Static Analyzer": {
                return "StaticAnalyzer";
            }
            case "Dynamic Analyzer": {
                return "DynamicAnalyzer";
            }
            case "Software Composition Analyzer": {
                return "ScaAnalyzer";
            }
        }
        return type;
    }

    public static String scanTypeShortForm(String type) {
        switch (type) {
            case "Static Analyzer": {
                return "Sast";
            }
            case "Dynamic Analyzer": {
                return "Dast";
            }
            case "Software Composition Analyzer": {
                return "Sca";
            }
        }
        return type;
    }

    public static String getServiceVersion(IAuthenticationProvider provider) {
        String request_url = provider.getServer() + "/assets/versions.json";
        HttpClient client = new HttpClient(provider.getProxy(), provider.getacceptInvalidCerts());
        try {
            HttpResponse response = client.get(request_url, null, null);
            if (response.isSuccess()) {
                JSONObject body = (JSONObject)response.getResponseBodyAsJSON();
                return body.getString("MainVersion");
            }
        }
        catch (IOException | JSONException e) {
            return "0";
        }
        return null;
    }

    public static boolean isValidDomain(String url, String appId, IAuthenticationProvider provider, Proxy proxy) {
        String request_url = provider.getServer() + "/api/v4/Domains/Verify";
        try {
            String responseContent;
            JSONObject body = new JSONObject();
            body.put("AppId", (Object)appId);
            body.put("STP", (Object)url);
            HttpClient client = new HttpClient(proxy, provider.getacceptInvalidCerts());
            Map<String, String> requestHeaders = provider.getAuthorizationHeader(false);
            requestHeaders.put("Content-Type", "application/json");
            HttpResponse response = client.post(request_url, requestHeaders, body.toString());
            if (response.isSuccess() && (responseContent = response.getResponseBodyAsString()) != null) {
                return Boolean.parseBoolean(responseContent.trim());
            }
        }
        catch (IOException | JSONException throwable) {
            // empty catch block
        }
        return false;
    }

    public static boolean compareVersions(String baseVersion, String newVersion) {
        if (baseVersion == null) {
            return true;
        }
        if (newVersion != null) {
            String[] base = baseVersion.split("\\.");
            String[] next = newVersion.split("\\.");
            try {
                for (int iter = 0; iter < base.length && iter < next.length; ++iter) {
                    int lVersion = Integer.parseInt(base[iter]);
                    int sVersion = Integer.parseInt(next[iter]);
                    if (!(iter == 0 && lVersion < sVersion || iter == 1 && lVersion < sVersion) && (iter != 2 || lVersion >= sVersion)) continue;
                    return true;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }
}

