/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.utils;

import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.utils.SystemUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ArchiveUtil {
    private static final double TOO_BIG = 4.0E9;
    private static final int BUFFER_SIZE = 4096;
    public static int MAX_PATH_LENGTH = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File source, File destDir) throws IOException {
        FileInputStream input = new FileInputStream(source);
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(input));
        destDir.mkdirs();
        ZipEntry entry = null;
        long bytesWritten = 0L;
        try {
            while ((entry = zip.getNextEntry()) != null) {
                String path = entry.getName();
                File newFile = new File(destDir, path);
                if (entry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    File parent = newFile.getParentFile();
                    parent.mkdirs();
                    if (parent.isDirectory()) {
                        bytesWritten += ArchiveUtil.write(zip, newFile);
                    }
                }
                if ((double)bytesWritten >= 4.0E9) {
                    throw new IOException(Messages.getMessage("err.too.big", new Object[0]));
                }
                newFile.setExecutable(true, false);
                newFile.setReadable(true, false);
                newFile.setWritable(true);
            }
        }
        finally {
            if (zip != null) {
                zip.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long write(InputStream input, File file) throws IOException {
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
        long bytesWritten = 0L;
        int len = 0;
        byte[] buffer = new byte[4096];
        try {
            while ((len = input.read(buffer)) != -1) {
                output.write(buffer, 0, len);
                bytesWritten += (long)len;
            }
            long l = bytesWritten;
            return l;
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static void zipFileOrFolder(File fileToZip, File zipFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(zipFile.getAbsolutePath());
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        ArchiveUtil.zipFile(fileToZip, fileToZip.getName(), zipOut);
        zipOut.close();
        fos.close();
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isDirectory()) {
            File[] children;
            for (File childFile : children = fileToZip.listFiles()) {
                ArchiveUtil.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    static {
        MAX_PATH_LENGTH = SystemUtil.isWindows() ? 256 : (SystemUtil.isMac() ? 1024 : 4096);
    }
}

