/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.sca;

import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.error.InvalidTargetException;
import com.hcl.appscan.sdk.error.ScannerException;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.scanners.sast.SASTConstants;
import com.hcl.appscan.sdk.scanners.sast.SASTScan;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class SCAScan
extends SASTScan
implements SASTConstants {
    private static final long serialVersionUID = 1L;

    public SCAScan(Map<String, String> properties, IProgress progress, IScanServiceProvider provider) {
        super(properties, progress, provider);
    }

    @Override
    public void run() throws ScannerException, InvalidTargetException {
        String target = this.getTarget();
        if (target == null || !new File(target).exists()) {
            throw new InvalidTargetException(Messages.getMessage("error.target.invalid", target));
        }
        try {
            if (this.getProperties().containsKey("ApplicationFileId")) {
                this.submitScan();
            } else {
                this.generateIR();
                this.analyzeIR();
            }
        }
        catch (IOException e) {
            throw new ScannerException(Messages.getMessage("error.scan.failed", e.getLocalizedMessage()));
        }
    }

    @Override
    public String getType() {
        return "Software Composition Analyzer";
    }

    @Override
    protected void submitScan() {
        this.setScanId(this.getServiceProvider().createAndExecuteScan("Sca", this.getProperties()));
    }
}

