/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.sast.xml;

import com.hcl.appscan.sdk.scanners.sast.targets.ISASTTarget;
import com.hcl.appscan.sdk.scanners.sast.xml.DOMWriter;
import com.hcl.appscan.sdk.scanners.sast.xml.IModelXMLConstants;
import com.hcl.appscan.sdk.scanners.sast.xml.ModelWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public class XmlWriter
extends ModelWriter
implements IModelXMLConstants {
    private DOMWriter m_config;
    private String m_configOutputDirectory = null;
    private String m_configFileName = "appscan-config.xml";
    private boolean m_useRelativePaths;

    public XmlWriter() {
        this(false);
    }

    public XmlWriter(boolean relativeTargetPaths) {
        this.m_useRelativePaths = relativeTargetPaths;
    }

    @Override
    public void initWriters(File directory) throws IOException {
        this.m_configOutputDirectory = directory.getCanonicalPath();
        try {
            this.initialize(directory);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        this.m_config = new DOMWriter(directory, this.m_configFileName, this.m_builder);
    }

    @Override
    public void visit(List<ISASTTarget> targets, boolean isThirdPartyScanningEnabled, boolean isOpenSourceOnlyEnabled, boolean isSourceCodeOnlyEnabled, boolean isStaticAnalysisOnlyEnabled, boolean isSecretsScanningDisabled, boolean isSecretsScanningEnabled, boolean isSecretsScanningOnlyEnabled) {
        this.m_config.beginElement("Configuration");
        if (isThirdPartyScanningEnabled) {
            this.m_config.setAttribute("thirdParty", "true");
        }
        if (isOpenSourceOnlyEnabled) {
            this.m_config.setAttribute("openSourceOnly", "true");
        }
        if (isSourceCodeOnlyEnabled) {
            this.m_config.setAttribute("sourceCodeOnly", "true");
        }
        if (isStaticAnalysisOnlyEnabled) {
            this.m_config.setAttribute("staticAnalysisOnly", "true");
        }
        if (isSecretsScanningDisabled) {
            this.m_config.setAttribute("noSecrets", "true");
        }
        if (isSecretsScanningEnabled) {
            this.m_config.setAttribute("enableSecrets", "true");
        }
        if (isSecretsScanningOnlyEnabled) {
            this.m_config.setAttribute("secretsOnly", "true");
        }
        this.m_config.beginElement("Targets");
        for (ISASTTarget target : targets) {
            this.m_config.beginElement("Target");
            this.m_config.setAttribute("path", this.getTargetPath(target));
            if (target.outputsOnly()) {
                this.m_config.setAttribute("outputs-only", "true");
            }
            if (target.getProperties().size() > 0) {
                this.m_config.beginElement("CustomBuildInfo");
                for (Map.Entry entry : target.getProperties().entrySet()) {
                    this.m_config.setAttribute((String)entry.getKey(), (String)entry.getValue());
                }
                this.m_config.endElement();
            }
            for (String string : target.getInclusionPatterns()) {
                this.m_config.beginElement("Include");
                this.m_config.endElement(string);
            }
            for (String string : target.getExclusionPatterns()) {
                this.m_config.beginElement("Exclude");
                this.m_config.endElement(string);
            }
            this.m_config.endElement();
        }
        this.m_config.endElement();
    }

    @Override
    public void write() throws TransformerException {
        this.m_transformer.setOutputProperty("omit-xml-declaration", "no");
        this.m_config.write(this.m_transformer);
    }

    @Override
    public String getOutputLocation() {
        return this.m_configOutputDirectory + File.separator + this.m_configFileName;
    }

    private String getTargetPath(ISASTTarget target) {
        if (target.getTargetFile() == null) {
            return target.getTarget();
        }
        if (!this.m_useRelativePaths) {
            return target.getTargetFile().getAbsolutePath();
        }
        Path targetPath = Paths.get(target.getTargetFile().getAbsolutePath(), new String[0]);
        Path base = Paths.get(this.m_configOutputDirectory, new String[0]);
        return base.relativize(targetPath).toString();
    }
}

