/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.sast.xml;

import com.hcl.appscan.sdk.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DOMWriter {
    private File m_file;
    private DocumentBuilder m_builder;
    private Document m_doc;
    private OutputStream m_stream;
    private Element m_current = null;

    public DOMWriter(File file, DocumentBuilder builder, boolean append) throws IOException {
        this.m_file = file;
        this.m_builder = builder;
        if (this.m_file.exists()) {
            if (append) {
                try {
                    this.m_doc = builder.parse(file);
                    this.m_current = this.m_doc.getDocumentElement();
                    return;
                }
                catch (SAXException e) {
                    throw new IOException(e);
                }
            }
            if (!this.m_file.delete()) {
                throw new IOException(Messages.getMessage("error.delete", this.m_file));
            }
        } else {
            this.m_file.getParentFile().mkdirs();
        }
        this.m_doc = builder.newDocument();
    }

    public DOMWriter(File file, DocumentBuilder builder) throws IOException {
        this(file, builder, false);
    }

    public DOMWriter(File directory, String file, DocumentBuilder builder) throws IOException {
        this(new File(directory, file), builder, false);
    }

    public DOMWriter(OutputStream stream, DocumentBuilder builder) {
        this.m_stream = stream;
        this.m_builder = builder;
        this.m_doc = builder.newDocument();
    }

    public void setAttribute(String name, String value) {
        block2: {
            try {
                this.m_current.setAttribute(name, value);
            }
            catch (DOMException e) {
                if (e.code == 5) break block2;
                throw e;
            }
        }
    }

    public void appendFragment(DocumentFragment fragment) {
        if (fragment != null) {
            Node newFragment = this.m_doc.importNode(fragment, true);
            this.m_current.appendChild(newFragment);
        }
    }

    public void appendFragment(String xml) throws IOException, SAXException {
        if (xml != null) {
            Document document = this.m_builder.parse(new InputSource(new StringReader(xml)));
            DocumentFragment fragment = document.createDocumentFragment();
            fragment.appendChild(document.getDocumentElement());
            this.appendFragment(fragment);
        }
    }

    public void appendNode(Node node) {
        if (node != null) {
            this.m_current.appendChild(node);
        }
    }

    public void beginElement(String name) {
        Element child = this.m_doc.createElement(name);
        if (this.m_current == null) {
            this.m_doc.appendChild(child);
        } else {
            this.m_current.appendChild(child);
        }
        this.m_current = child;
    }

    public void endElement() {
        Node parent = this.m_current.getParentNode();
        if (parent instanceof Element) {
            this.m_current = (Element)parent;
        }
    }

    public void endElement(String data, boolean isCData) {
        if (data != null) {
            if (this.m_current.hasChildNodes()) {
                throw new IllegalStateException(Messages.getMessage("error.dom.state", new Object[0]));
            }
            this.m_current.appendChild(isCData ? this.m_doc.createCDATASection(data) : this.m_doc.createTextNode(data));
        }
        this.endElement();
    }

    public void endElement(String data) {
        this.endElement(data, false);
    }

    public void write(Transformer transformer) throws TransformerException {
        DOMSource source = new DOMSource(this.m_doc);
        boolean shouldCloseAfter = false;
        try {
            if (this.m_stream == null) {
                this.m_stream = new FileOutputStream(this.m_file);
                shouldCloseAfter = true;
            }
            StreamResult result = new StreamResult(this.m_stream);
            transformer.transform(source, result);
        }
        catch (IOException e) {
            throw new TransformerException(e);
        }
        finally {
            if (this.m_stream != null && shouldCloseAfter) {
                try {
                    this.m_stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.m_stream = null;
            }
        }
    }

    public Document getDocument() {
        return this.m_doc;
    }
}

