/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.sast;

import com.hcl.appscan.sdk.error.InvalidTargetException;
import com.hcl.appscan.sdk.error.ScannerException;
import com.hcl.appscan.sdk.logging.DefaultProgress;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.results.CloudCombinedResultsProvider;
import com.hcl.appscan.sdk.results.IResultsProvider;
import com.hcl.appscan.sdk.results.NonCompliantIssuesResultProvider;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.scanners.sast.SASTScan;
import com.hcl.appscan.sdk.scanners.sca.SCAScan;
import java.util.Map;

public class SAST_SCA_Scan
extends SASTScan {
    private static final long serialVersionUID = 1L;
    private String m_sastScanId;
    private String m_scaScanId;
    private SCAScan m_scaScan;

    public SAST_SCA_Scan(Map<String, String> properties, IScanServiceProvider provider) {
        super(properties, new DefaultProgress(), provider);
        this.m_scaScan = new SCAScan(properties, new DefaultProgress(), provider);
        this.m_scaScan.setTarget(this.getTarget());
    }

    public SAST_SCA_Scan(Map<String, String> properties, IProgress progress, IScanServiceProvider provider) {
        super(properties, progress, provider);
        this.m_scaScan = new SCAScan(properties, progress, provider);
        this.m_scaScan.setTarget(this.getTarget());
    }

    @Override
    public void run() throws ScannerException, InvalidTargetException {
        super.run();
        if (this.getProperties().containsKey("prepareOnly")) {
            return;
        }
        this.m_sastScanId = this.getScanId();
        this.m_scaScan.run();
        this.m_scaScanId = this.m_scaScan.getScanId();
    }

    @Override
    public IResultsProvider getResultsProvider() {
        return this.getProvider(this.getResultsProvider(), this.m_scaScan.getResultsProvider());
    }

    @Override
    public IResultsProvider getResultsProvider(boolean nonCompliantIssues) {
        if (nonCompliantIssues) {
            NonCompliantIssuesResultProvider provider1 = new NonCompliantIssuesResultProvider(this.getScanId(), this.getType(), this.getServiceProvider(), this.getProgress());
            NonCompliantIssuesResultProvider provider2 = new NonCompliantIssuesResultProvider(this.m_scaScan.getScanId(), this.m_scaScan.getType(), this.m_scaScan.getServiceProvider(), this.m_scaScan.getProgress());
            return this.getProvider(provider1, provider2);
        }
        return this.getResultsProvider();
    }

    public String getSastScanId() {
        return this.m_sastScanId;
    }

    public String getScaScanId() {
        return this.m_scaScanId;
    }

    private IResultsProvider getProvider(IResultsProvider provider1, IResultsProvider provider2) {
        CloudCombinedResultsProvider combinedProvider = new CloudCombinedResultsProvider(provider1, provider2);
        combinedProvider.setReportFormat(this.getReportFormat());
        return combinedProvider;
    }
}

