/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.sast;

import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.error.ScannerException;
import com.hcl.appscan.sdk.logging.DefaultProgress;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.scanners.sast.SASTConstants;
import com.hcl.appscan.sdk.utils.ArchiveUtil;
import com.hcl.appscan.sdk.utils.FileUtil;
import com.hcl.appscan.sdk.utils.ServiceUtil;
import com.hcl.appscan.sdk.utils.SystemUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SAClient
implements SASTConstants {
    private static final File DEFAULT_INSTALL_DIR = new File(System.getProperty("user.home"), ".appscan");
    private static final String SACLIENT = "SAClientUtil";
    private static final String SACLIENT_SUBDIR_MAC = "Contents" + File.separator + "Home" + File.separator;
    private static final String VERSION_INFO = "version.info";
    private IProgress m_progress;
    private ProcessBuilder m_builder;
    private File m_installDir;
    private Proxy m_proxy;

    public SAClient() {
        this(new DefaultProgress(), Proxy.NO_PROXY);
    }

    public SAClient(Proxy proxy) {
        this(new DefaultProgress(), proxy);
    }

    public SAClient(IProgress progress) {
        this(progress, Proxy.NO_PROXY);
    }

    public SAClient(IProgress progress, Proxy proxy) {
        this.m_progress = progress;
        String install = System.getProperty("SAClientInstall");
        this.m_installDir = install == null ? DEFAULT_INSTALL_DIR : new File(install);
        this.m_proxy = proxy;
    }

    public int run(String workingDir, Map<String, String> properties) throws IOException, ScannerException {
        return this.runClient(workingDir, this.getClientArgs(properties), properties.get("APPSCAN_IRGEN_CLIENT"), properties.get("APPSCAN_CLIENT_VERSION"), properties.get("IRGEN_CLIENT_PLUGIN_VERSION"), properties.get("serverURL"), properties.get("acceptInvalidCerts"));
    }

    @Deprecated
    public int run(String workingDir, List<String> args) throws IOException, ScannerException {
        return this.runClient(workingDir, args, "", "", "");
    }

    private int runClient(String workingDir, List<String> args, String irGenClient, String clientVersion, String irgenClientPluginVersion) throws IOException, ScannerException {
        return this.runClient(workingDir, args, irGenClient, clientVersion, irgenClientPluginVersion, "", "");
    }

    private int runClient(String workingDir, List<String> args, String irGenClient, String clientVersion, String irgenClientPluginVersion, String serverURL, String acceptInvalidCerts) throws IOException, ScannerException {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(this.getClientScript(serverURL, acceptInvalidCerts));
        arguments.addAll(args);
        this.m_builder = new ProcessBuilder(arguments);
        this.m_builder.directory(new File(workingDir));
        this.m_builder.redirectErrorStream(true);
        if (irGenClient != null && !irGenClient.isEmpty()) {
            this.m_builder.environment().put("APPSCAN_IRGEN_CLIENT", irGenClient);
        }
        if (clientVersion != null && !clientVersion.isEmpty()) {
            this.m_builder.environment().put("APPSCAN_CLIENT_VERSION", clientVersion);
        }
        if (irgenClientPluginVersion != null && !irgenClientPluginVersion.isEmpty()) {
            this.m_builder.environment().put("IRGEN_CLIENT_PLUGIN_VERSION", irgenClientPluginVersion);
        }
        this.m_progress.setStatus(new Message(0, Messages.getMessage("message.preparing.irx", this.getLocalClientVersion())));
        if (serverURL != null && !serverURL.isEmpty()) {
            String options;
            String string = options = System.getenv("APPSCAN_OPTS") == null ? "" : System.getenv("APPSCAN_OPTS");
            if ("true".equals(acceptInvalidCerts)) {
                options = options + " -Dacceptssl";
            }
            this.m_builder.environment().put("APPSCAN_OPTS", options);
        }
        final Process proc = this.m_builder.start();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                try {
                    String line;
                    while ((line = reader.readLine()) != null) {
                        SAClient.this.m_progress.setStatus(new Message(0, line));
                    }
                }
                catch (IOException e) {
                    SAClient.this.m_progress.setStatus(e);
                }
                finally {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        SAClient.this.m_progress.setStatus(e);
                    }
                }
            }
        }).start();
        try {
            proc.waitFor();
        }
        catch (InterruptedException e) {
            this.m_progress.setStatus(e);
            return -1;
        }
        return proc.exitValue();
    }

    public String getClientScript() throws IOException, ScannerException {
        return this.getClientScript("", "");
    }

    public String getClientScript(String serverURL, String acceptInvalidCerts) throws IOException, ScannerException {
        File clientZip;
        String scriptPath = "bin" + File.separator + this.getScriptName();
        String scriptPathMac = SACLIENT_SUBDIR_MAC + scriptPath;
        File install = this.findClientInstall();
        if (SystemUtil.isMac() && new File(install, scriptPathMac).isFile() && !this.shouldUpdateClient(serverURL, Boolean.parseBoolean(acceptInvalidCerts))) {
            return new File(install, scriptPathMac).getAbsolutePath();
        }
        if (install != null && new File(install, scriptPath).isFile() && !this.shouldUpdateClient(serverURL, Boolean.parseBoolean(acceptInvalidCerts))) {
            return new File(install, scriptPath).getAbsolutePath();
        }
        this.m_progress.setStatus(new Message(0, Messages.getMessage("message.downloading.client", new Object[0])));
        if (install != null && install.isDirectory()) {
            this.deleteDirectory(install);
        }
        if ((clientZip = new File(this.m_installDir, "SAClientUtil.zip")).isFile()) {
            clientZip.delete();
        }
        try {
            ServiceUtil.getSAClientUtil(clientZip, this.m_proxy, serverURL, acceptInvalidCerts);
        }
        catch (OutOfMemoryError e) {
            throw new ScannerException(Messages.getMessage("error.out.of.memory", new Object[0]));
        }
        catch (IOException e) {
            throw new ScannerException(Messages.getMessage("error.download.client", e.getLocalizedMessage()));
        }
        if (clientZip.isFile()) {
            this.m_progress.setStatus(new Message(0, Messages.getMessage("message.download.complete", new Object[0])));
            this.m_progress.setStatus(new Message(0, Messages.getMessage("message.extracting.client", new Object[0])));
            ArchiveUtil.unzip(clientZip, this.m_installDir);
            this.m_progress.setStatus(new Message(0, Messages.getMessage("message.done", new Object[0])));
        }
        if (SystemUtil.isMac() && new File(install, scriptPathMac).isFile()) {
            return new File(install, scriptPathMac).getAbsolutePath();
        }
        return new File(this.findClientInstall(), scriptPath).getAbsolutePath();
    }

    private String getScriptName() {
        return SystemUtil.isWindows() ? "appscan.bat" : "appscan.sh";
    }

    public boolean majorVersionChanged() throws IOException {
        String serverMajorVersion = ServiceUtil.getSAClientVersion(this.m_proxy);
        String localMajorVersion = this.getLocalClientVersion();
        if (serverMajorVersion != null && localMajorVersion != null) {
            serverMajorVersion = serverMajorVersion.substring(0, 1);
            return !(localMajorVersion = localMajorVersion.substring(0, 1)).equals(serverMajorVersion);
        }
        this.m_progress.setStatus(new Message(0, Messages.getMessage("message.server.unavailable", new Object[0])));
        return false;
    }

    public boolean shouldUpdateClient() throws IOException {
        return this.shouldUpdateClient("");
    }

    public boolean shouldUpdateClient(String serverURL) throws IOException {
        return this.shouldUpdateClient(serverURL, false);
    }

    public boolean shouldUpdateClient(String serverURL, boolean acceptInvalidCerts) throws IOException {
        String serverVersion = ServiceUtil.getSAClientVersion(this.m_proxy, serverURL, acceptInvalidCerts);
        String localVersion = this.getLocalClientVersion();
        if (this.compareVersions(localVersion, serverVersion) && System.getProperty("skipUpdate") == null) {
            this.m_progress.setStatus(new Message(0, Messages.getMessage("message.saclient.old", localVersion, serverVersion)));
            return true;
        }
        return false;
    }

    private File findClientInstall() {
        if (!this.m_installDir.isDirectory()) {
            return null;
        }
        File[] files = this.m_installDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(SAClient.SACLIENT) && new File(dir, name).isDirectory();
            }
        });
        if (files.length > 1) {
            File latest = files[0];
            String latestVersion = this.getVersionFromString(latest.getName());
            for (int i = 1; i < files.length; ++i) {
                String otherVersion = this.getVersionFromString(files[i].getName());
                if (this.compareVersions(latestVersion, otherVersion)) {
                    this.deleteDirectory(latest);
                    latest = files[i];
                    latestVersion = this.getVersionFromString(latest.getName());
                    continue;
                }
                this.deleteDirectory(files[i]);
            }
            return latest;
        }
        return files.length == 0 ? null : files[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLocalClientVersion() {
        File versionInfo = new File(this.findClientInstall(), VERSION_INFO);
        if (SystemUtil.isMac() && !versionInfo.isFile()) {
            versionInfo = new File(this.findClientInstall(), SACLIENT_SUBDIR_MAC + VERSION_INFO);
        }
        String version = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(versionInfo));
            version = reader.readLine();
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.checking.local.version", e.getLocalizedMessage())));
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return version;
    }

    private void deleteDirectory(File directory) {
        if (!directory.isDirectory()) {
            directory.delete();
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                this.deleteDirectory(file);
                continue;
            }
            file.delete();
        }
        directory.delete();
    }

    private List<String> getClientArgs(Map<String, String> properties) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("prepare");
        if (properties.containsKey("ScanName")) {
            args.add("-n");
            args.add(FileUtil.getValidFilename(properties.get("ScanName")));
        }
        if (properties.containsKey("logDir")) {
            args.add("-l");
            args.add(properties.get("logDir"));
        }
        if (properties.containsKey("irxDir")) {
            args.add("-d");
            args.add(properties.get("irxDir"));
        }
        if (properties.containsKey("configFile")) {
            args.add("-c");
            args.add(properties.get("configFile"));
        }
        if (properties.containsKey("debug") || System.getProperty("debug".toUpperCase()) != null) {
            args.add("-X");
        }
        if (properties.containsKey("verbose")) {
            args.add("-v");
        }
        if (properties.containsKey("thirdParty") || System.getProperty("thirdParty") != null) {
            args.add("-t");
        }
        if (properties.containsKey("openSourceOnly") || System.getProperty("openSourceOnly") != null || properties.getOrDefault("type", "").equals("Software Composition Analyzer")) {
            args.add("-oso");
        }
        if (properties.containsKey("sourceCodeOnly") || System.getProperty("sourceCodeOnly") != null) {
            args.add("-sco");
        }
        if (!properties.containsKey("includeSCA") && !properties.containsKey("openSourceOnly") && properties.getOrDefault("type", "").equals("Static Analyzer")) {
            args.add("-sao");
        }
        if (properties.containsKey("scanSpeed")) {
            args.add("-s");
            if (properties.get("scanSpeed").equals("normal")) {
                args.add("thorough");
            } else if (properties.get("scanSpeed").equals("fast")) {
                args.add("deep");
            } else if (properties.get("scanSpeed").equals("faster")) {
                args.add("balanced");
            } else if (properties.get("scanSpeed").equals("fastest")) {
                args.add("simple");
            } else {
                args.add(properties.get("scanSpeed"));
            }
        }
        if (properties.containsKey("enableSecrets") || System.getProperty("enableSecrets") != null) {
            args.add("-es");
        }
        if (properties.containsKey("secretsOnly") || System.getProperty("secretsOnly") != null) {
            args.add("-so");
        }
        if (Boolean.parseBoolean(properties.getOrDefault("acceptInvalidCerts", Boolean.toString(false)))) {
            args.add("-acceptssl");
        }
        if (properties.get("serverURL") != null && properties.get("serverURL").trim() != "") {
            args.add("-DBLUEMIX_SERVER=" + properties.get("serverURL"));
        }
        return args;
    }

    public boolean compareVersions(String baseVersion, String newVersion) {
        return ServiceUtil.compareVersions(baseVersion, newVersion);
    }

    private String getVersionFromString(String name) {
        String version = name.substring(SACLIENT.length());
        if (version.trim().startsWith(".")) {
            version = version.substring(1);
        }
        return version;
    }
}

