/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scanners.dynamic;

import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.error.InvalidTargetException;
import com.hcl.appscan.sdk.error.ScannerException;
import com.hcl.appscan.sdk.logging.DefaultProgress;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.scanners.ASoCScan;
import com.hcl.appscan.sdk.scanners.dynamic.DASTConstants;
import com.hcl.appscan.sdk.utils.ServiceUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class DASTScan
extends ASoCScan
implements DASTConstants {
    private static final long serialVersionUID = 1L;
    private static final String REPORT_FORMAT = "html";

    public DASTScan(Map<String, String> properties, IScanServiceProvider provider) {
        super(properties, new DefaultProgress(), provider);
    }

    public DASTScan(Map<String, String> properties, IProgress progress, IScanServiceProvider provider) {
        super(properties, progress, provider);
    }

    @Override
    public void run() throws ScannerException, InvalidTargetException {
        String scanFile;
        String type = "Dast";
        String target = this.getTarget();
        if (target == null) {
            throw new InvalidTargetException(Messages.getMessage("error.target.invalid", target));
        }
        Map<String, String> params = this.getProperties();
        params.put("StartingUrl", target);
        IAuthenticationProvider authProvider = this.getServiceProvider().getAuthenticationProvider();
        if (params.get("PresenceId") != null && params.get("PresenceId").isEmpty() && !ServiceUtil.isValidUrl(target, authProvider, authProvider.getProxy())) {
            throw new ScannerException(Messages.getMessage("error.url.validation", target));
        }
        String scanLoginType = null;
        if (params.get("LoginType") != null) {
            scanLoginType = params.get("LoginType");
        }
        if ("Manual".equals(scanLoginType)) {
            String trafficFile = params.remove("trafficFile");
            if (trafficFile != null && new File(trafficFile).isFile()) {
                File fileTraffic = new File(trafficFile);
                try {
                    String fileTrafficId = this.getServiceProvider().submitFile(fileTraffic);
                    if (fileTrafficId == null) {
                        throw new ScannerException(Messages.getMessage("error.file.upload", fileTraffic.getName()));
                    }
                    params.put("LoginSequenceFileId", fileTrafficId);
                }
                catch (IOException e) {
                    throw new ScannerException(Messages.getMessage("error.scan.failed", e.getLocalizedMessage()));
                }
            } else if (trafficFile != null) {
                throw new ScannerException(Messages.getMessage("error.file.upload", trafficFile));
            }
        }
        if ((scanFile = params.remove("ScanFile")) != null && new File(scanFile).isFile()) {
            File file = new File(scanFile);
            try {
                String fileId = this.getServiceProvider().submitFile(file);
                if (fileId == null) {
                    throw new ScannerException(Messages.getMessage("error.file.upload", file.getName()));
                }
                params.put("ScanOrTemplateFileId", fileId);
            }
            catch (IOException e) {
                throw new ScannerException(Messages.getMessage("error.scan.failed", e.getLocalizedMessage()));
            }
        }
        try {
            JSONObject propertiesJSON = this.createJSONForProperties(params);
            if (this.getRescan()) {
                this.setScanId(params.get("ScanId"));
                this.setExecutionId(this.getServiceProvider().rescan(this.getScanId(), (Map<String, String>)propertiesJSON));
                if (this.getExecutionId() == null) {
                    throw new ScannerException(Messages.getMessage("error.creating.scan", new Object[0]));
                }
            } else {
                this.setScanId(this.getServiceProvider().createAndExecuteScan(type, (Map<String, String>)propertiesJSON));
                if (this.getScanId() == null) {
                    throw new ScannerException(Messages.getMessage("error.creating.scan", new Object[0]));
                }
            }
        }
        catch (JSONException e) {
            throw new ScannerException(Messages.getMessage("error.running.scan", e.getLocalizedMessage()));
        }
    }

    private JSONObject createJSONForProperties(Map<String, String> params) throws JSONException {
        JSONObject json = new JSONObject(params);
        if (!params.containsKey("ScanOrTemplateFileId")) {
            return json.put("ScanConfiguration", (Map)this.createScanConfiguration(json));
        }
        return json;
    }

    private JSONObject createScanConfiguration(JSONObject json) throws JSONException {
        JSONObject scanConfiguration = new JSONObject();
        scanConfiguration.put("Target", (Map)this.createTarget(json));
        if ("Automatic".equals(json.get("LoginType"))) {
            scanConfiguration.put("Login", (Map)this.createLogin(json));
        }
        scanConfiguration.put("Tests", (Map)this.createTests(json));
        return scanConfiguration;
    }

    private JSONObject createTarget(JSONObject json) throws JSONException {
        return new JSONObject().put("StartingUrl", json.remove((Object)"StartingUrl"));
    }

    private JSONObject createLogin(JSONObject json) throws JSONException {
        JSONObject login = new JSONObject();
        if (json.containsKey((Object)"LoginUser") && json.containsKey((Object)"LoginPassword")) {
            login.put("UserName", json.remove((Object)"LoginUser"));
            login.put("Password", json.remove((Object)"LoginPassword"));
        }
        if (json.containsKey((Object)"ExtraField")) {
            login.put("ExtraField", json.remove((Object)"ExtraField"));
        }
        return login;
    }

    private JSONObject createTests(JSONObject json) throws JSONException {
        return new JSONObject().put("TestOptimizationLevel", json.remove((Object)"TestOptimizationLevel"));
    }

    @Override
    public String getType() {
        return "Dynamic Analyzer";
    }

    @Override
    public String getReportFormat() {
        return REPORT_FORMAT;
    }
}

