/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scan;

import com.hcl.appscan.sdk.CoreConstants;
import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.app.CloudApplicationProvider;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.http.HttpClient;
import com.hcl.appscan.sdk.http.HttpPart;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.logging.DefaultProgress;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.utils.FileUtil;
import com.hcl.appscan.sdk.utils.ServiceUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONArtifact;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class CloudScanServiceProvider
implements IScanServiceProvider,
Serializable,
CoreConstants {
    private static final long serialVersionUID = 1L;
    private IProgress m_progress;
    private IAuthenticationProvider m_authProvider;
    private static final String[] DAST_FILES_EXTENSIONS = new String[]{"scan", "scant", "config"};

    public CloudScanServiceProvider(IProgress progress, IAuthenticationProvider authProvider) {
        this.m_progress = progress;
        this.m_authProvider = authProvider;
    }

    public CloudScanServiceProvider(IAuthenticationProvider authProvider) {
        this(new DefaultProgress(), authProvider);
    }

    @Override
    public String createAndExecuteScan(String type, Map<String, String> params) {
        String requestUrl = this.m_authProvider.getServer() + String.format("/api/v4/Scans/%s", type);
        String progressMessage = Messages.getMessage("message.created.scan", type.toUpperCase());
        String overviewMessage = Messages.getMessage("message.scan.overview", type.toUpperCase());
        return this.executeScan(requestUrl, params, progressMessage, overviewMessage);
    }

    @Override
    public String rescan(String scanId, Map<String, String> params) {
        String requestUrl = this.m_authProvider.getServer() + String.format("/api/v4/Scans/%s/Executions", scanId);
        HashMap<String, String> updateParams = new HashMap<String, String>();
        updateParams.put("Name", params.remove("ScanName"));
        updateParams.put("EnableMailNotifications", params.remove("EnableMailNotification"));
        updateParams.put("FullyAutomatic", params.remove("FullyAutomatic"));
        this.updateScanData(updateParams, scanId);
        String progressMessage = Messages.getMessage("message.rescan", new Object[0]);
        String overviewMessage = Messages.getMessage("message.rescan.overview", new Object[0]);
        return this.executeScan(requestUrl, params, progressMessage, overviewMessage);
    }

    private String executeScan(String requestUrl, Map<String, String> params, String successMessageKey, String overviewMessageKey) {
        if (this.loginExpired() || params.containsKey("AppId") && !this.verifyApplication(params.get("AppId").toString())) {
            return null;
        }
        Map<String, String> requestHeaders = this.m_authProvider.getAuthorizationHeader(true);
        HttpClient client = new HttpClient(this.m_authProvider.getProxy(), this.m_authProvider.getacceptInvalidCerts());
        try {
            requestHeaders.put("Content-Type", "application/json");
            requestHeaders.put("accept", "application/json");
            HttpResponse response = client.post(requestUrl, requestHeaders, params);
            int status = response.getResponseCode();
            JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
            if (status == 201 || status == 200) {
                String scanOverviewUrl;
                String id = json.getString("Id");
                if (params.containsKey("ScanId")) {
                    String scanId = params.get("ScanId");
                    scanOverviewUrl = this.m_authProvider.getServer() + "/main/myapps/" + params.get("AppId") + "/scans/" + scanId;
                } else {
                    scanOverviewUrl = this.m_authProvider.getServer() + "/main/myapps/" + params.get("AppId") + "/scans/" + id;
                }
                this.m_progress.setStatus(new Message(0, successMessageKey + " " + id));
                this.m_progress.setStatus(new Message(0, overviewMessageKey + " " + scanOverviewUrl));
                return id;
            }
            if (json != null && json.has("Message")) {
                JSONArray jsonArray;
                String errorResponse = json.getString("Message");
                if (json.has("FormatParams") && !json.isNull("FormatParams") && (jsonArray = json.getJSONArray("FormatParams")) != null) {
                    String[] messageParams = new String[jsonArray.size()];
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        messageParams[i] = (String)jsonArray.get(i);
                    }
                    errorResponse = MessageFormat.format(errorResponse, messageParams);
                }
                this.m_progress.setStatus(new Message(2, errorResponse));
            } else {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.submit.scan", status)));
            }
        }
        catch (IOException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.submit.scan", e.getLocalizedMessage())));
        }
        return null;
    }

    @Override
    public String submitFile(File file) throws IOException {
        if (this.loginExpired()) {
            return null;
        }
        this.m_progress.setStatus(new Message(0, Messages.getMessage("message.uploading.file", file.getAbsolutePath())));
        String fileUploadAPI = this.m_authProvider.getServer() + "/api/v4/FileUpload";
        if (!file.getName().toLowerCase().endsWith(".irx") && !Arrays.asList(DAST_FILES_EXTENSIONS).contains(FileUtil.getFileExtension(file))) {
            fileUploadAPI = fileUploadAPI + "?fileType=SourceCodeArchive";
        }
        ArrayList<HttpPart> parts = new ArrayList<HttpPart>();
        parts.add(new HttpPart("uploadedFile", file, "multipart/form-data"));
        HttpClient client = new HttpClient(this.m_authProvider.getProxy(), this.m_authProvider.getacceptInvalidCerts());
        try {
            HttpResponse response = client.postMultipart(fileUploadAPI, this.m_authProvider.getAuthorizationHeader(true), parts);
            JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
            if (!object.has("Message")) {
                return object.getString("FileId");
            }
            this.m_progress.setStatus(new Message(2, object.getString("Message")));
        }
        catch (JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.upload.file", file, e.getLocalizedMessage())));
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public JSONObject getScanDetails(String scanId) throws IOException, JSONException {
        if (this.loginExpired()) {
            return null;
        }
        String request_url = this.m_authProvider.getServer() + "/api/v4/Scans";
        request_url = request_url + "?$filter=Id%20eq%20" + scanId;
        Map<String, String> request_headers = this.m_authProvider.getAuthorizationHeader(true);
        HttpClient client = new HttpClient(this.m_authProvider.getProxy(), this.m_authProvider.getacceptInvalidCerts());
        try {
            HttpResponse response = client.get(request_url, request_headers, null);
            if (response.getResponseCode() == 200 || response.getResponseCode() == 201) {
                JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
                JSONArray array = (JSONArray)obj.get("Items");
                if (!array.isEmpty()) return array.getJSONObject(0);
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.details.scan.id", scanId)));
            } else if (response.getResponseCode() == -1) {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.details.scan.id", scanId)));
            } else if (response.getResponseCode() != 400) {
                JSONArtifact json = response.getResponseBodyAsJSON();
                if (json != null && ((JSONObject)json).has("Message")) {
                    this.m_progress.setStatus(new Message(2, ((JSONObject)json).getString("Message")));
                }
                if (response.getResponseCode() == 403 && json != null && ((JSONObject)json).has("Key") && ((JSONObject)json).get("Key").equals("UNAUTHORIZED_ACTION")) {
                    return (JSONObject)json;
                }
            }
            if (response.getResponseCode() != 400) return null;
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.invalid.job.id", scanId)));
            return null;
        }
        catch (IOException | JSONException e) {
            return new JSONObject().put("Status", (Object)"Unknown");
        }
    }

    public JSONObject getScanDetails(String type, String scanId) {
        if (this.loginExpired()) {
            return null;
        }
        String request_url = this.m_authProvider.getServer() + String.format("/api/v4/Scans/%s/%s", ServiceUtil.scanTypeShortForm(type), scanId);
        Map<String, String> request_headers = this.m_authProvider.getAuthorizationHeader(true);
        request_headers.put("accept", "application/json");
        request_headers.put("Content-Type", "application/json");
        HttpClient client = new HttpClient(this.m_authProvider.getProxy(), this.m_authProvider.getacceptInvalidCerts());
        try {
            HttpResponse response = client.get(request_url, request_headers, null);
            if (response.isSuccess()) {
                return (JSONObject)response.getResponseBodyAsJSON();
            }
        }
        catch (IOException | JSONException throwable) {
            // empty catch block
        }
        return null;
    }

    @Override
    public JSONArray getNonCompliantIssues(String scanId) throws IOException, JSONException {
        return this.getNonCompliantIssues("Scan", scanId);
    }

    @Override
    public JSONArray getNonCompliantIssuesUsingExecutionId(String executionId) throws IOException, JSONException {
        return this.getNonCompliantIssues("ScanExecution", executionId);
    }

    private JSONArray getNonCompliantIssues(String idType, String id) throws IOException, JSONException {
        if (this.loginExpired()) {
            return null;
        }
        String requestUrl = this.m_authProvider.getServer() + String.format("/api/v4/Issues/%s/%s", idType, id);
        requestUrl = requestUrl + "?applyPolicies=All&%24filter=Status%20eq%20%27Open%27%20or%20Status%20eq%20%27InProgress%27%20or%20Status%20eq%20%27Reopened%27&%24apply=groupby%28%28Status%2CSeverity%29%2Caggregate%28%24count%20as%20N%29%29";
        Map<String, String> requestHeaders = this.m_authProvider.getAuthorizationHeader(true);
        requestHeaders.put("Content-Type", "application/json; charset=UTF-8");
        requestHeaders.put("Accept", "application/json");
        HttpClient client = new HttpClient(this.m_authProvider.getProxy(), this.m_authProvider.getacceptInvalidCerts());
        HttpResponse response = client.get(requestUrl, requestHeaders, null);
        if (response.isSuccess()) {
            JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
            return json.getJSONArray("Items");
        }
        if (response.getResponseCode() == 400) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.info", idType, id)));
        } else {
            JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
            if (obj != null && obj.has("Message")) {
                this.m_progress.setStatus(new Message(2, obj.getString("Message")));
            } else {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.details", response.getResponseCode())));
            }
        }
        return null;
    }

    @Override
    public IAuthenticationProvider getAuthenticationProvider() {
        return this.m_authProvider;
    }

    private boolean loginExpired() {
        if (this.m_authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return true;
        }
        return false;
    }

    private boolean verifyApplication(String appId) {
        CloudApplicationProvider provider;
        if (appId != null && !appId.trim().equals("") && (provider = new CloudApplicationProvider(this.m_authProvider)).getApplications() != null && provider.getApplications().keySet().contains(appId)) {
            return true;
        }
        this.m_progress.setStatus(new Message(2, Messages.getMessage("error.invalid.app", appId)));
        return false;
    }

    @Override
    public void setProgress(IProgress progress) {
        this.m_progress = progress;
    }

    @Override
    public JSONArray getBaseScanDetails(String scanId) {
        if (this.loginExpired()) {
            return null;
        }
        String request_url = this.m_authProvider.getServer() + String.format("/api/v4/Scans/%s/Executions", scanId);
        request_url = request_url + "?$filter=IsValidForIncremental%20eq%20true&%24select=Id%2C%20CreatedAt%2C%20IsValidForIncremental&%24orderby=CreatedAt%20desc";
        Map<String, String> request_headers = this.m_authProvider.getAuthorizationHeader(true);
        request_headers.put("accept", "application/json");
        request_headers.put("Content-Type", "application/json");
        HttpClient client = new HttpClient(this.m_authProvider.getProxy(), this.m_authProvider.getacceptInvalidCerts());
        try {
            HttpResponse response = client.get(request_url, request_headers, null);
            if (response.isSuccess()) {
                return (JSONArray)response.getResponseBodyAsJSON();
            }
        }
        catch (IOException | JSONException throwable) {
            // empty catch block
        }
        return null;
    }

    public void updateScanData(Map<String, String> params, String scanId) {
        if (this.loginExpired()) {
            return;
        }
        String request_url = this.m_authProvider.getServer() + String.format("/api/v4/Scans/%s", scanId);
        Map<String, String> request_headers = this.m_authProvider.getAuthorizationHeader(true);
        request_headers.put("accept", "application/json");
        request_headers.put("Content-Type", "application/json");
        HttpClient client = new HttpClient(this.m_authProvider.getProxy(), this.m_authProvider.getacceptInvalidCerts());
        try {
            HttpResponse response = client.put(request_url, request_headers, params);
            if (response.getResponseCode() == 204) {
                this.m_progress.setStatus(new Message(0, Messages.getMessage("message.update.job", new Object[0])));
            }
        }
        catch (IOException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.update.job", e.getLocalizedMessage())));
        }
    }
}

