/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.scan;

import com.hcl.appscan.sdk.CoreConstants;
import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.auth.IASEAuthenticationProvider;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.http.HttpPart;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.http.HttpsClient;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.scan.ASEScanType;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class ASEScanServiceProvider
implements IScanServiceProvider,
Serializable,
CoreConstants {
    private IProgress m_progress;
    private IASEAuthenticationProvider m_authProvider;

    public ASEScanServiceProvider(IProgress progress, IAuthenticationProvider authProvider) {
        this.m_progress = progress;
        this.m_authProvider = (IASEAuthenticationProvider)authProvider;
    }

    @Override
    public String createAndExecuteScan(String type, Map<String, String> params) {
        String jobId = this.createJob(params);
        if (jobId != null) {
            jobId = this.updateJob(params, jobId);
        }
        if (jobId != null && this.runScanJob(jobId)) {
            return jobId;
        }
        return null;
    }

    private String createJob(Map<String, String> params) {
        if (this.loginExpired()) {
            return null;
        }
        Map<String, String> createJobParams = this.getcreateJobParams(params);
        this.m_progress.setStatus(new Message(0, Messages.getMessage("message.creating.job", new Object[0])));
        String templateId = createJobParams.get("templateId");
        createJobParams.remove("templateId");
        String request_url = this.m_authProvider.getServer() + String.format("/api/jobs/%s/dastconfig/createjob", templateId);
        Map<String, String> request_headers = this.getRequestHeaders();
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.postForm(request_url, request_headers, createJobParams);
            int status = response.getResponseCode();
            if (status == 400 || status == 404) {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.create.job", Messages.getMessage("error.invalid.details", new Object[0]))));
                return null;
            }
            JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
            if (status == 201) {
                this.m_progress.setStatus(new Message(0, Messages.getMessage("message.created.job", new Object[0])));
                return json.getString("id");
            }
            if (json != null && json.has("Message")) {
                this.m_progress.setStatus(new Message(2, json.getString("Message")));
            } else {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.create.job", status)));
            }
        }
        catch (IOException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.create.job", e.getLocalizedMessage())));
        }
        return null;
    }

    private Map<String, String> getcreateJobParams(Map<String, String> properties) {
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("testPolicyId", properties.get("testPolicyId"));
        apiParams.put("folderId", properties.get("folder"));
        apiParams.put("applicationId", properties.get("application"));
        apiParams.put("name", properties.get("ScanName"));
        apiParams.put("templateId", properties.get("templateId"));
        apiParams.put("description", properties.get("description"));
        apiParams.put("contact", properties.get("contact"));
        return apiParams;
    }

    private String updateJob(Map<String, String> params, String jobId) {
        String scanTypeValue = params.getOrDefault("scanType", "");
        if (!this.handleStartingURL(params, jobId, scanTypeValue)) {
            return null;
        }
        if (!this.handleAgentServer(params, jobId)) {
            return null;
        }
        if (!this.handleLoginManagement(params, jobId)) {
            return null;
        }
        if (!this.handleExploreData(params, jobId)) {
            return null;
        }
        if (!this.handleScanType(params, jobId, scanTypeValue)) {
            return null;
        }
        if (!this.handleTestOptimization(params, jobId)) {
            return null;
        }
        if (!this.handlePostmanCollection(params, jobId, scanTypeValue)) {
            return null;
        }
        return jobId;
    }

    private boolean handleStartingURL(Map<String, String> params, String jobId, String scanType) {
        return scanType.equals("Postman Collection") || params.get("startingURL").isEmpty() || this.updatescantJob(this.getUpdatescantJobParams("StartingUrl", params.get("startingURL"), "false"), jobId);
    }

    private boolean handleAgentServer(Map<String, String> params, String jobId) {
        return params.get("agentServer").isEmpty() || this.updateAgentServer(params, jobId);
    }

    private boolean handleLoginManagement(Map<String, String> params, String jobId) {
        File trafficFile;
        String loginType = params.getOrDefault("loginType", "");
        if (loginType.isEmpty()) {
            return true;
        }
        if (!this.updatescantJob(this.getUpdatescantJobParams("LoginMethod", loginType, "false"), jobId)) {
            return false;
        }
        if (loginType.equals("Automatic")) {
            if (!this.updatescantJob(this.getUpdatescantJobParams("LoginUsername", params.get("userName"), "false"), jobId)) {
                return false;
            }
            if (!this.updatescantJob(this.getUpdatescantJobParams("LoginPassword", params.get("password"), "true"), jobId)) {
                return false;
            }
        }
        return !loginType.equals("Manual") || (trafficFile = this.getFile(params.get("trafficFile"))) == null || this.updateTrafficJob(trafficFile, jobId, "login");
    }

    private boolean handleExploreData(Map<String, String> params, String jobId) {
        String exploreData = params.getOrDefault("exploreData", "");
        return exploreData.isEmpty() || this.updateTrafficJob(this.getFile(exploreData), jobId, "add");
    }

    private boolean handleScanType(Map<String, String> params, String jobId, String scanType) {
        return scanType.isEmpty() || scanType.equals("Postman Collection") || this.updateScanTypeJob(params, jobId);
    }

    private boolean handleTestOptimization(Map<String, String> params, String jobId) {
        String testOpt = params.getOrDefault("testOptimization", "");
        return testOpt.isEmpty() || this.updatescantJob(this.getUpdatescantJobParams("TestOptimization", testOpt, "false"), jobId);
    }

    private boolean handlePostmanCollection(Map<String, String> params, String jobId, String scanType) {
        return !scanType.equals("Postman Collection") || this.createPostmanCollectionJob(params, jobId);
    }

    private boolean updatescantJob(Map<String, String> params, String jobId) {
        if (this.loginExpired()) {
            return false;
        }
        String request_url = this.m_authProvider.getServer() + String.format("/api/jobs/%s/dastconfig/updatescant", jobId);
        Map<String, String> request_headers = this.getRequestHeaders();
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.postForm(request_url, request_headers, params);
            int status = response.getResponseCode();
            if (status != 200) {
                return false;
            }
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.update.job", e.getLocalizedMessage())));
            return false;
        }
        return true;
    }

    private boolean updateScanTypeJob(Map<String, String> params, String jobId) {
        if (this.loginExpired()) {
            return false;
        }
        String request_url = this.m_authProvider.getServer() + String.format("/api/jobs/scantype", new Object[0]) + "?scanTypeId=" + ASEScanType.scanTypeCode(params.get("scanType")) + "&jobId=" + jobId;
        Map<String, String> request_headers = this.getRequestHeaders();
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.put(request_url, request_headers, null);
            int status = response.getResponseCode();
            if (status != 200) {
                return false;
            }
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.update.job", e.getLocalizedMessage())));
            return false;
        }
        return true;
    }

    private boolean updateTrafficJob(File file, String jobId, String action) {
        if (this.loginExpired() || file == null) {
            return false;
        }
        String request_url = this.m_authProvider.getServer() + String.format("/api/jobs/%s/dastconfig/updatetraffic/%s", jobId, action);
        Map<String, String> request_headers = this.getRequestHeaders();
        ArrayList<HttpPart> parts = new ArrayList<HttpPart>();
        try {
            parts.add(new HttpPart("uploadedfile", file, "multipart/form-data"));
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.update.job", e.getLocalizedMessage())));
            return false;
        }
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.postMultipart(request_url, request_headers, parts);
            int status = response.getResponseCode();
            if (status != 200) {
                JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
                if (json != null && json.has("errorMessage")) {
                    this.m_progress.setStatus(new Message(2, json.getString("errorMessage")));
                }
                return false;
            }
        }
        catch (IOException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.update.job", e.getLocalizedMessage())));
            return false;
        }
        return true;
    }

    private boolean updateAgentServer(Map<String, String> params, String jobId) {
        if (this.loginExpired()) {
            return false;
        }
        String request_url = this.m_authProvider.getServer() + String.format("/api/jobs/%s/designateAgentServer/%s", jobId, params.get("agentServer"));
        Map<String, String> request_headers = this.getRequestHeaders();
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.postForm(request_url, request_headers, params);
            int status = response.getResponseCode();
            if (status != 200) {
                return false;
            }
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.update.job", e.getLocalizedMessage())));
            return false;
        }
        return true;
    }

    private Map<String, String> getUpdatescantJobParams(String scantNodeXpath, String scantNodeNewValue, String encryptNodeValue) {
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("scantNodeXpath", scantNodeXpath);
        apiParams.put("scantNodeNewValue", scantNodeNewValue);
        apiParams.put("encryptNodeValue", encryptNodeValue);
        return apiParams;
    }

    private boolean createPostmanCollectionJob(Map<String, String> params, String jobId) {
        if (this.loginExpired() || params == null) {
            return false;
        }
        String request_url = this.m_authProvider.getServer() + String.format("/api/jobs/%s/dastconfig/postman/create", jobId);
        Map<String, String> request_headers = this.getRequestHeaders();
        ArrayList<HttpPart> parts = new ArrayList<HttpPart>();
        HttpsClient client = new HttpsClient();
        try {
            this.addAllFileParts(params, parts);
            if (params.containsKey("additionalDomains")) {
                parts.add(new HttpPart("additionalDomains", params.get("additionalDomains")));
            }
            parts.add(new HttpPart("asc_xsrf_token", request_headers.get("asc_xsrf_token")));
            HttpResponse response = client.postMultipart(request_url, request_headers, parts);
            int status = response.getResponseCode();
            if (status != 200) {
                JSONObject json = (JSONObject)response.getResponseBodyAsJSON();
                if (json != null && json.has("errorMessage")) {
                    this.m_progress.setStatus(new Message(2, json.getString("errorMessage")));
                } else {
                    this.m_progress.setStatus(new Message(2, Messages.getMessage("error.update.job", status)));
                }
                return false;
            }
            this.m_progress.setStatus(new Message(0, Messages.getMessage("update.postman.collection.success", jobId)));
        }
        catch (IOException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.update.job", e.getLocalizedMessage())));
            return false;
        }
        return true;
    }

    private File getFile(String fileLocation) {
        if (fileLocation != null && new File(fileLocation).isFile()) {
            File file = new File(fileLocation);
            return file;
        }
        this.m_progress.setStatus(new Message(2, Messages.getMessage("error.file.not.found", fileLocation)));
        return null;
    }

    private void addAllFileParts(Map<String, String> params, List<HttpPart> parts) throws IOException {
        String[][] filePartMappings;
        for (String[] mapping : filePartMappings = new String[][]{{"postmanCollectionFile", "postmanCollectionFile"}, {"environmentalVariablesFile", "postmanEnvironmentFile"}, {"globalVariablesFile", "postmanGlobalFile"}, {"additionalFiles", "postmanAdditionalFiles"}}) {
            this.addFilePart(params, parts, mapping[0], mapping[1]);
        }
    }

    private void addFilePart(Map<String, String> params, List<HttpPart> parts, String paramKey, String partName) throws IOException {
        File file;
        String filePath = params.get(paramKey);
        if (filePath != null && !filePath.isEmpty() && (file = this.getFile(filePath)) != null) {
            parts.add(new HttpPart(partName, file, "multipart/form-data"));
        }
    }

    private boolean runScanJob(String jobId) {
        if (this.loginExpired()) {
            return false;
        }
        this.m_progress.setStatus(new Message(0, Messages.getMessage("message.running.job", new Object[0])));
        String eTag = "";
        eTag = this.getEtag(jobId);
        String request_url = this.m_authProvider.getServer() + String.format("/api/jobs/%s/actions", jobId);
        Map<String, String> request_headers = this.getRequestHeaders();
        request_headers.put("If-Match", eTag);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", "run");
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.postForm(request_url, request_headers, params);
            int status = response.getResponseCode();
            if (status == 200) {
                this.m_progress.setStatus(new Message(0, Messages.getMessage("message.executed.job", new Object[0])));
                return true;
            }
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.execute.job", status)));
        }
        catch (IOException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.execute.job", e.getLocalizedMessage())));
        }
        return false;
    }

    private String getEtag(String jobId) {
        if (this.loginExpired()) {
            return null;
        }
        String request_url = this.m_authProvider.getServer() + String.format("/api/jobs/%s", jobId);
        Map<String, String> request_headers = this.getRequestHeaders();
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.get(request_url, request_headers, null);
            int status = response.getResponseCode();
            if (status == 200) {
                return response.getHeaderField("ETag");
            }
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }

    private boolean loginExpired() {
        if (this.m_authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return true;
        }
        return false;
    }

    @Override
    public String submitFile(File file) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JSONObject getScanDetails(String jobId) throws IOException, JSONException {
        Map<String, String> request_headers;
        if (this.loginExpired()) {
            return null;
        }
        String reportPackId = this.getReportPackId(jobId);
        HttpsClient client = new HttpsClient();
        String request_url = this.m_authProvider.getServer() + String.format("/api/folderitems/%s/reports", reportPackId);
        HttpResponse response = client.get(request_url, request_headers = this.getRequestHeaders(), null);
        if (response.getResponseCode() == 200 || response.getResponseCode() == 201) {
            return this.getResultJson(response);
        }
        if (response.getResponseCode() == 400) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.invalid.job.id", jobId)));
        }
        return null;
    }

    @Override
    public JSONArray getNonCompliantIssues(String scanId) throws IOException, JSONException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public JSONArray getNonCompliantIssuesUsingExecutionId(String executionId) throws IOException, JSONException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String rescan(String scanId, Map<String, String> params) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IAuthenticationProvider getAuthenticationProvider() {
        return this.m_authProvider;
    }

    @Override
    public void setProgress(IProgress progress) {
        this.m_progress = progress;
    }

    @Override
    public JSONArray getBaseScanDetails(String scanId) {
        return null;
    }

    private String getReportPackId(String jobId) {
        return String.valueOf(Integer.parseInt(jobId) + 1);
    }

    private JSONObject getResultJson(HttpResponse response) {
        try {
            JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
            JSONObject reportsObject = object.getJSONObject("reports");
            JSONArray reports = reportsObject.getJSONArray("report");
            for (Object obj : reports.toArray()) {
                JSONObject reportObject = (JSONObject)obj;
                if (!reportObject.getString("name").equalsIgnoreCase("Security Issues")) continue;
                JSONObject result = new JSONObject();
                JSONObject issueCountsSeverity = reportObject.getJSONObject("issue-counts-severity");
                JSONArray issueCount = issueCountsSeverity.getJSONArray("issue-count");
                int totalCount = 0;
                block17: for (Object severity : issueCount.toArray()) {
                    JSONObject severityCount = (JSONObject)severity;
                    JSONObject severityDetails = severityCount.getJSONObject("severity");
                    int count = Integer.parseInt(severityCount.getString("count"));
                    switch (severityDetails.getString("name")) {
                        case "Critical": {
                            result.put("NCriticalIssues", count);
                            totalCount += count;
                            continue block17;
                        }
                        case "High": {
                            result.put("NHighIssues", count);
                            totalCount += count;
                            continue block17;
                        }
                        case "Medium": {
                            result.put("NMediumIssues", count);
                            totalCount += count;
                            continue block17;
                        }
                        case "Low": {
                            result.put("NLowIssues", count);
                            totalCount += count;
                            continue block17;
                        }
                        case "Information": {
                            result.put("NInfoIssues", count);
                            totalCount += count;
                            continue block17;
                        }
                        default: {
                            totalCount += count;
                        }
                    }
                }
                result.put("NIssuesFound", totalCount);
                return result;
            }
        }
        catch (IOException | JSONException ex) {
            Logger.getLogger(ASEScanServiceProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private Map<String, String> getRequestHeaders() {
        Map<String, String> request_headers = this.m_authProvider.getAuthorizationHeader(true);
        request_headers.put("Content-Type", "application/json; utf-8");
        request_headers.put("charset", "utf-8");
        request_headers.put("Accept", "application/json");
        return request_headers;
    }
}

