/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.results;

import com.hcl.appscan.sdk.CoreConstants;
import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.http.HttpClient;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.results.IResultsProvider;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class CloudResultsProvider
implements IResultsProvider,
Serializable,
CoreConstants {
    private static final long serialVersionUID = 1L;
    protected String m_type;
    protected String m_scanId;
    protected String m_status;
    private String m_reportFormat;
    private boolean m_hasResults;
    protected IScanServiceProvider m_scanProvider;
    protected IProgress m_progress;
    protected String m_message;
    protected int m_totalFindings;
    protected int m_criticalFindings;
    protected int m_highFindings;
    protected int m_mediumFindings;
    protected int m_lowFindings;
    protected int m_infoFindings;
    protected String m_executionId;

    public CloudResultsProvider(String scanId, String type, IScanServiceProvider provider, IProgress progress) {
        this(scanId, null, type, provider, progress);
    }

    public CloudResultsProvider(String scanId, String executionId, String type, IScanServiceProvider provider, IProgress progress) {
        this.m_type = type;
        this.m_scanId = scanId;
        this.m_executionId = executionId;
        this.m_hasResults = false;
        this.m_scanProvider = provider;
        this.m_progress = progress;
        this.m_reportFormat = "html";
    }

    @Override
    public void getResultsFile(File file, String format) {
        if (format == null) {
            format = this.getResultsFormat();
        }
        if (file != null && !file.exists()) {
            try {
                this.getReport(this.m_scanId, format, file);
            }
            catch (IOException | JSONException e) {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.result", new Object[0])), e);
            }
        }
    }

    @Override
    public Collection<?> getFindings() {
        return null;
    }

    @Override
    public int getFindingsCount() {
        this.checkResults();
        return this.m_totalFindings;
    }

    @Override
    public int getCriticalCount() {
        this.checkResults();
        return this.m_criticalFindings;
    }

    @Override
    public int getHighCount() {
        this.checkResults();
        return this.m_highFindings;
    }

    @Override
    public int getMediumCount() {
        this.checkResults();
        return this.m_mediumFindings;
    }

    @Override
    public int getLowCount() {
        this.checkResults();
        return this.m_lowFindings;
    }

    @Override
    public int getInfoCount() {
        this.checkResults();
        return this.m_infoFindings;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public boolean hasResults() {
        this.checkResults();
        return this.m_hasResults;
    }

    protected void setHasResult(boolean value) {
        this.m_hasResults = value;
    }

    @Override
    public String getStatus() {
        this.checkResults();
        return this.m_status;
    }

    @Override
    public String getResultsFormat() {
        return this.m_reportFormat;
    }

    @Override
    public String getMessage() {
        return this.m_message;
    }

    @Override
    public void setProgress(IProgress progress) {
        this.m_progress = progress;
        this.m_scanProvider.setProgress(progress);
    }

    @Override
    public void setReportFormat(String format) {
        this.m_reportFormat = format;
    }

    protected void loadResults() {
        try {
            JSONObject items = this.m_scanProvider.getScanDetails(this.m_scanId);
            JSONObject obj = items.getJSONObject("LatestExecution");
            this.m_status = obj.getString("Status");
            if (this.m_status != null && !this.m_status.equalsIgnoreCase("InQueue") && !this.m_status.equalsIgnoreCase("Running")) {
                this.m_totalFindings = obj.getInt("NIssuesFound");
                this.m_criticalFindings = obj.getInt("NCriticalIssues");
                this.m_highFindings = obj.getInt("NHighIssues");
                this.m_mediumFindings = obj.getInt("NMediumIssues");
                this.m_lowFindings = obj.getInt("NLowIssues");
                this.m_infoFindings = obj.getInt("NInfoIssues");
                this.m_hasResults = true;
            }
        }
        catch (IOException | NullPointerException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.details", e.getMessage())), e);
            this.m_status = "Failed";
        }
    }

    protected void getReport(String scanId, String format, File destination) throws IOException, JSONException {
        IAuthenticationProvider authProvider = this.m_scanProvider.getAuthenticationProvider();
        if (authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return;
        }
        String request_url = authProvider.getServer() + String.format("/api/v4/Scans/%s/Report/%s", scanId, format);
        Map<String, String> request_headers = authProvider.getAuthorizationHeader(true);
        request_headers.put("Content-Length", "0");
        HttpClient client = new HttpClient(this.m_scanProvider.getAuthenticationProvider().getProxy(), this.m_scanProvider.getAuthenticationProvider().getacceptInvalidCerts());
        HttpResponse response = client.get(request_url, request_headers, null);
        if (response.getResponseCode() == 200) {
            if (destination.isDirectory()) {
                String fileName = "asoc_results_" + SystemUtil.getTimeStamp() + "." + format;
                destination = new File(destination, fileName);
            }
            destination.getParentFile().mkdirs();
            response.getResponseBodyAsFile(destination);
        } else {
            JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
            if (object.has("Message")) {
                if (response.getResponseCode() == 400) {
                    this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.result", new Object[0])));
                } else {
                    this.m_progress.setStatus(new Message(2, object.getString("Message")));
                }
            }
        }
    }

    private void checkResults() {
        if (!this.m_hasResults) {
            this.loadResults();
        }
    }

    protected String getReportStatus(String reportId) throws IOException, JSONException {
        IAuthenticationProvider authProvider = this.m_scanProvider.getAuthenticationProvider();
        if (authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return "Failed";
        }
        String request_url = authProvider.getServer() + "/api/v4/Reports";
        request_url = request_url + "?%24top=100&%24filter=Id%20eq%20" + reportId + "&%24count=false";
        Map<String, String> request_headers = authProvider.getAuthorizationHeader(true);
        request_headers.put("Content-Length", "0");
        HttpClient client = new HttpClient(this.m_scanProvider.getAuthenticationProvider().getProxy(), this.m_scanProvider.getAuthenticationProvider().getacceptInvalidCerts());
        HttpResponse response = client.get(request_url, request_headers, null);
        if (response.getResponseCode() != 200) {
            return null;
        }
        JSONObject obj = (JSONObject)response.getResponseBodyAsJSON();
        JSONArray array = obj.getJSONArray("Items");
        JSONObject json = (JSONObject)array.get(0);
        return json.getString("Status");
    }

    public void getScanLogFile(File file, String scanId) {
        if (file != null && !file.exists()) {
            try {
                this.getScanLog(scanId, file);
            }
            catch (IOException | JSONException e) {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.scanlog", new Object[0])), e);
            }
        }
    }

    @Override
    public void getScanLogFile(File file) {
        this.getScanLogFile(file, this.m_scanId);
    }

    private void getScanLog(String scanId, File destination) throws IOException, JSONException {
        IAuthenticationProvider authProvider = this.m_scanProvider.getAuthenticationProvider();
        if (authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return;
        }
        String request_url = authProvider.getServer() + String.format("/api/v4/Scans/ScanLogs/%s", scanId);
        Map<String, String> request_headers = authProvider.getAuthorizationHeader(true);
        request_headers.put("Content-Length", "0");
        HttpClient client = new HttpClient(this.m_scanProvider.getAuthenticationProvider().getProxy(), this.m_scanProvider.getAuthenticationProvider().getacceptInvalidCerts());
        HttpResponse response = client.get(request_url, request_headers, null);
        if (response.isSuccess()) {
            if (destination.isDirectory()) {
                String fileName = "ScanLog_" + SystemUtil.getTimeStamp() + ".zip";
                destination = new File(destination, fileName);
            }
            destination.getParentFile().mkdirs();
            response.getResponseBodyAsFile(destination);
        } else {
            JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
            if (object.has("Message")) {
                this.m_progress.setStatus(new Message(2, object.getString("Message")));
            } else {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.scanlog", new Object[0])));
            }
        }
    }
}

