/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.results;

import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.results.IResultsProvider;
import com.hcl.appscan.sdk.utils.ServiceUtil;
import java.io.File;
import java.io.Serializable;
import java.util.Collection;

public class CloudCombinedResultsProvider
implements IResultsProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private IResultsProvider m_resultsProvider1;
    private IResultsProvider m_resultsProvider2;
    private String m_status1;
    private String m_status2;
    private String m_reportFormat = "html";

    public CloudCombinedResultsProvider(IResultsProvider resultsProvider1, IResultsProvider resultsProvider2) {
        this.m_resultsProvider1 = resultsProvider1;
        this.m_resultsProvider2 = resultsProvider2;
    }

    @Override
    public boolean hasResults() {
        return this.getStatus().equals("PartialSuccess") ? this.m_resultsProvider1.hasResults() || this.m_resultsProvider2.hasResults() : this.m_resultsProvider1.hasResults() && this.m_resultsProvider2.hasResults();
    }

    public IResultsProvider getResultsProvider1() {
        return this.m_resultsProvider1;
    }

    public IResultsProvider getResultsProvider2() {
        return this.m_resultsProvider2;
    }

    @Override
    public String getStatus() {
        String combinedStatus = "Running";
        if (this.m_status1 == null || this.m_status1.equalsIgnoreCase("Running")) {
            this.m_status1 = this.m_resultsProvider1.getStatus();
        }
        if (this.m_status2 == null || this.m_status2.equalsIgnoreCase("Running")) {
            this.m_status2 = this.m_resultsProvider2.getStatus();
        }
        if (this.m_status1.equals(this.m_status2)) {
            combinedStatus = this.m_status1;
        } else if (("Ready".equalsIgnoreCase(this.m_status1) || "Ready".equalsIgnoreCase(this.m_status2)) && ("Failed".equalsIgnoreCase(this.m_status1) || "Failed".equalsIgnoreCase(this.m_status2))) {
            combinedStatus = "PartialSuccess";
        }
        return combinedStatus;
    }

    @Override
    public Collection<?> getFindings() {
        return null;
    }

    @Override
    public int getFindingsCount() {
        return this.m_resultsProvider1.getFindingsCount() + this.m_resultsProvider2.getFindingsCount();
    }

    @Override
    public int getCriticalCount() {
        return this.m_resultsProvider1.getCriticalCount() + this.m_resultsProvider2.getCriticalCount();
    }

    @Override
    public int getHighCount() {
        return this.m_resultsProvider1.getHighCount() + this.m_resultsProvider2.getHighCount();
    }

    @Override
    public int getMediumCount() {
        return this.m_resultsProvider1.getMediumCount() + this.m_resultsProvider2.getMediumCount();
    }

    @Override
    public int getLowCount() {
        return this.m_resultsProvider1.getLowCount() + this.m_resultsProvider2.getLowCount();
    }

    @Override
    public int getInfoCount() {
        return this.m_resultsProvider1.getInfoCount() + this.m_resultsProvider2.getInfoCount();
    }

    @Override
    public String getType() {
        return this.m_resultsProvider1.getType() + "_" + this.m_resultsProvider2.getType();
    }

    @Override
    public void getResultsFile(File destination, String format) {
        String name1 = ServiceUtil.scanTypeShortForm(this.m_resultsProvider1.getType()).toUpperCase() + "_" + destination.getName();
        String name2 = ServiceUtil.scanTypeShortForm(this.m_resultsProvider2.getType()).toUpperCase() + "_" + destination.getName();
        File directory = destination.getParentFile();
        this.m_resultsProvider1.getResultsFile(new File(directory, name1), format);
        this.m_resultsProvider2.getResultsFile(new File(directory, name2), format);
    }

    @Override
    public String getResultsFormat() {
        return this.m_reportFormat;
    }

    @Override
    public String getMessage() {
        if (this.m_resultsProvider1.getMessage() != null && this.m_resultsProvider2.getMessage() != null) {
            return this.m_resultsProvider1.getType() + ": " + this.m_resultsProvider1.getMessage() + "\n" + this.m_resultsProvider2.getType() + ": " + this.m_resultsProvider2.getMessage();
        }
        return null;
    }

    @Override
    public void setReportFormat(String format) {
        this.m_reportFormat = format;
        this.m_resultsProvider1.setReportFormat(format);
        this.m_resultsProvider2.setReportFormat(format);
    }

    @Override
    public void setProgress(IProgress progress) {
        this.m_resultsProvider1.setProgress(progress);
        this.m_resultsProvider2.setProgress(progress);
    }

    @Override
    public void getScanLogFile(File file) {
        if (this.m_status1 != null && this.m_status1.equalsIgnoreCase("Ready")) {
            this.m_resultsProvider1.getScanLogFile(file);
        }
    }
}

