/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.results;

import com.hcl.appscan.sdk.CoreConstants;
import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.http.HttpsClient;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.results.IResultsProvider;
import com.hcl.appscan.sdk.scan.ASEScanServiceProvider;
import com.hcl.appscan.sdk.scan.IScanServiceProvider;
import com.hcl.appscan.sdk.utils.SystemUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class ASEResultsProvider
implements IResultsProvider,
Serializable,
CoreConstants {
    private static final long serialVersionUID = 1L;
    private static String DEFAULT_REPORT_FORMAT = "json";
    private String m_type;
    private String m_scanId;
    private String m_status;
    private String m_reportFormat;
    private boolean m_hasResults;
    private IScanServiceProvider m_scanProvider;
    private IProgress m_progress;
    private String m_message;
    private String m_scanName;
    private int m_totalFindings;
    private int m_highFindings;
    private int m_mediumFindings;
    private int m_lowFindings;
    private int m_criticalFindings;
    private int m_infoFindings;

    public ASEResultsProvider(String scanId, String type, IScanServiceProvider provider, IProgress progress, String scanName) {
        this.m_type = type;
        this.m_scanId = scanId;
        this.m_hasResults = false;
        this.m_scanProvider = provider;
        this.m_progress = progress;
        this.m_reportFormat = DEFAULT_REPORT_FORMAT;
        this.m_scanName = scanName;
    }

    @Override
    public void getResultsFile(File file, String format) {
        if (format == null) {
            format = this.getResultsFormat();
        }
        if (file != null && !file.exists()) {
            try {
                this.getReport(this.m_scanId, format, file);
            }
            catch (IOException | JSONException e) {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.result", new Object[0])), e);
            }
        }
    }

    @Override
    public Collection<?> getFindings() {
        return null;
    }

    @Override
    public int getFindingsCount() {
        this.checkResults();
        return this.m_totalFindings;
    }

    @Override
    public int getCriticalCount() {
        this.checkResults();
        return this.m_criticalFindings;
    }

    @Override
    public int getHighCount() {
        this.checkResults();
        return this.m_highFindings;
    }

    @Override
    public int getMediumCount() {
        this.checkResults();
        return this.m_mediumFindings;
    }

    @Override
    public int getLowCount() {
        this.checkResults();
        return this.m_lowFindings;
    }

    @Override
    public int getInfoCount() {
        this.checkResults();
        return this.m_infoFindings;
    }

    @Override
    public String getType() {
        return this.m_type;
    }

    @Override
    public boolean hasResults() {
        this.checkResults();
        return this.m_hasResults;
    }

    protected void setHasResult(boolean value) {
        this.m_hasResults = value;
    }

    @Override
    public String getStatus() {
        this.checkResults();
        return this.m_status;
    }

    @Override
    public String getResultsFormat() {
        return this.m_reportFormat;
    }

    @Override
    public String getMessage() {
        return this.m_message;
    }

    @Override
    public void setReportFormat(String format) {
        this.m_reportFormat = format;
    }

    @Override
    public void setProgress(IProgress progress) {
        this.m_progress = progress;
        this.m_scanProvider.setProgress(progress);
    }

    private void loadResults() {
        try {
            this.m_status = this.getScanStatus(this.m_scanId);
            if (this.m_status == null) {
                this.m_status = "Failed";
            } else if (this.m_status.equalsIgnoreCase("Ready")) {
                this.m_message = "";
                this.m_status = this.getReportPackStatus(this.m_scanId);
            }
            if (this.m_status != null && this.m_status.equals("Ready")) {
                JSONObject obj = this.m_scanProvider.getScanDetails(this.m_scanId);
                if (obj == null) {
                    this.m_message = Messages.getMessage("message.results.unavailable", new Object[0]);
                    throw new NullPointerException(Messages.getMessage("message.results.unavailable", new Object[0]));
                }
                this.m_totalFindings = obj.getInt("NIssuesFound");
                this.m_criticalFindings = obj.getInt("NCriticalIssues");
                this.m_highFindings = obj.getInt("NHighIssues");
                this.m_mediumFindings = obj.getInt("NMediumIssues");
                this.m_lowFindings = obj.getInt("NLowIssues");
                this.m_infoFindings = obj.getInt("NInfoIssues");
                this.m_hasResults = true;
                this.m_message = "";
            } else if ("Running".equalsIgnoreCase(this.m_status)) {
                this.m_message = "";
            } else if ("Canceling".equalsIgnoreCase(this.m_status)) {
                this.m_status = "Failed";
            } else if (this.m_status.startsWith("Suspended")) {
                this.m_message = this.m_status;
                String description = "";
                boolean isSuspendedByUser = false;
                if (this.m_status.contains("(") && this.m_status.contains(")") && "by user".equals((description = this.m_status.substring(this.m_status.indexOf("(") + 1, this.m_status.indexOf(")"))).toLowerCase())) {
                    this.m_progress.setStatus(new Message(0, Messages.getMessage("message.suspend.job.byuser", "Scan Name: " + this.m_scanName)));
                    this.m_message = Messages.getMessage("message.suspend.job.byuser", "Scan Name: " + this.m_scanName);
                    isSuspendedByUser = true;
                }
                if (!isSuspendedByUser) {
                    this.m_progress.setStatus(new Message(2, Messages.getMessage("error.running.scan", this.m_status)));
                    this.m_message = Messages.getMessage("error.running.scan", this.m_status);
                    this.m_status = "Failed";
                }
            }
        }
        catch (IOException | NullPointerException | JSONException e) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.details", e.getMessage())));
            this.m_status = "Failed";
        }
    }

    private void getReport(String scanId, String format, File destination) throws IOException, JSONException {
        Map<String, String> request_headers;
        IAuthenticationProvider authProvider = this.m_scanProvider.getAuthenticationProvider();
        if (authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return;
        }
        String reportPackId = this.getReportPackId(scanId);
        HttpsClient client = new HttpsClient();
        String request_url = authProvider.getServer() + String.format("/api/folderitems/%s/reports", reportPackId);
        HttpResponse response = client.get(request_url, request_headers = authProvider.getAuthorizationHeader(true), null);
        if (response.getResponseCode() == 200) {
            if (destination.isDirectory()) {
                String fileName = "asoc_results_" + SystemUtil.getTimeStamp() + "." + format;
                destination = new File(destination, fileName);
            }
            destination.getParentFile().mkdirs();
            JSONObject json = this.getResultJson(response);
            FileWriter writer = new FileWriter(destination);
            writer.write(json.toString());
            writer.flush();
        } else {
            JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
            if (object.has("Message")) {
                if (response.getResponseCode() == 400) {
                    this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.result", new Object[0])));
                } else {
                    this.m_progress.setStatus(new Message(2, object.getString("Message")));
                }
            }
        }
    }

    private JSONObject getResultJson(HttpResponse response) {
        try {
            JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
            JSONObject reportsObject = object.getJSONObject("reports");
            JSONArray reports = reportsObject.getJSONArray("report");
            for (Object obj : reports.toArray()) {
                JSONObject reportObject = (JSONObject)obj;
                if (!reportObject.getString("name").equalsIgnoreCase("Security Issues")) continue;
                return reportObject;
            }
        }
        catch (IOException | JSONException ex) {
            Logger.getLogger(ASEScanServiceProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private void checkResults() {
        if (!this.m_hasResults) {
            this.loadResults();
        }
    }

    private String getReportPackId(String scanId) {
        return String.valueOf(Integer.parseInt(scanId) + 1);
    }

    private String getScanStatus(String jobId) {
        IAuthenticationProvider authProvider = this.m_scanProvider.getAuthenticationProvider();
        if (authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return null;
        }
        String request_url = authProvider.getServer() + String.format("/api/folderitems/%s", jobId);
        Map<String, String> request_headers = authProvider.getAuthorizationHeader(true);
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.get(request_url, request_headers, null);
            if (response.getResponseCode() == 200) {
                JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
                JSONObject reportPack = object.getJSONObject("content-scan-job");
                JSONObject state = reportPack.getJSONObject("state");
                return state.getString("name");
            }
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.result", "")));
        }
        catch (IOException | JSONException ex) {
            Logger.getLogger(ASEResultsProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private String getReportPackStatus(String jobId) {
        IAuthenticationProvider authProvider = this.m_scanProvider.getAuthenticationProvider();
        if (authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return null;
        }
        String reportPackId = this.getReportPackId(jobId);
        String request_url = authProvider.getServer() + String.format("/api/folderitems/%s", reportPackId);
        Map<String, String> request_headers = authProvider.getAuthorizationHeader(true);
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.get(request_url, request_headers, null);
            if (response.getResponseCode() == 200) {
                JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
                JSONObject reportPack = object.getJSONObject("report-pack");
                JSONObject state = reportPack.getJSONObject("state");
                return state.getString("name");
            }
            this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.result", "")));
        }
        catch (IOException | JSONException ex) {
            Logger.getLogger(ASEResultsProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    private String getStatisticsStatus(String jobId) {
        IAuthenticationProvider authProvider = this.m_scanProvider.getAuthenticationProvider();
        if (authProvider.isTokenExpired()) {
            this.m_progress.setStatus(new Message(2, Messages.getMessage("login.token.expired", new Object[0])));
            return null;
        }
        String request_url = authProvider.getServer() + String.format("/api/folderitems/%s/statistics", jobId);
        Map<String, String> request_headers = authProvider.getAuthorizationHeader(true);
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.get(request_url, request_headers, null);
            if (response.getResponseCode() == 200) {
                JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
                if (object != null) {
                    String state;
                    JSONObject reportPack = object.has("statistics") ? object.getJSONObject("statistics") : null;
                    String string = state = reportPack != null && reportPack.has("status") ? reportPack.getString("status") : null;
                    if (state != null) {
                        return state;
                    }
                }
            } else {
                this.m_progress.setStatus(new Message(2, Messages.getMessage("error.getting.result", "")));
            }
        }
        catch (IOException | JSONException ex) {
            Logger.getLogger(ASEResultsProvider.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    @Override
    public void getScanLogFile(File file) {
    }
}

