/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.configuration.ase;

import com.hcl.appscan.sdk.auth.IASEAuthenticationProvider;
import com.hcl.appscan.sdk.configuration.ase.IComponent;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.http.HttpsClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.json4j.JSONArray;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class ASETemplateProvider
implements IComponent {
    private Map<String, String> m_templates;
    private IASEAuthenticationProvider m_authProvider;

    public ASETemplateProvider(IASEAuthenticationProvider provider) {
        this.m_authProvider = provider;
    }

    @Override
    public Map<String, String> getComponents() {
        if (this.m_templates == null) {
            this.loadTemplates();
        }
        return this.m_templates;
    }

    @Override
    public String getComponentName(String id) {
        return this.getComponents().get(id);
    }

    private void loadTemplates() {
        if (this.m_authProvider.isTokenExpired()) {
            return;
        }
        this.m_templates = new HashMap<String, String>();
        String url = this.m_authProvider.getServer() + "/api/templates";
        Map<String, String> headers = this.m_authProvider.getAuthorizationHeader(true);
        HttpsClient client = new HttpsClient();
        try {
            HttpResponse response = client.get(url, headers, null);
            if (!response.isSuccess()) {
                return;
            }
            JSONArray array = (JSONArray)response.getResponseBodyAsJSON();
            if (array == null) {
                return;
            }
            for (int i = 0; i < array.length(); ++i) {
                JSONObject object = array.getJSONObject(i);
                String id = object.getString("id");
                String path = object.getString("name");
                this.m_templates.put(id, path);
            }
        }
        catch (IOException | JSONException e) {
            this.m_templates = null;
        }
    }
}

