/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.sdk.auth;

import com.hcl.appscan.sdk.CoreConstants;
import com.hcl.appscan.sdk.Messages;
import com.hcl.appscan.sdk.auth.IASEAuthenticationProvider;
import com.hcl.appscan.sdk.error.HttpException;
import com.hcl.appscan.sdk.http.HttpResponse;
import com.hcl.appscan.sdk.http.HttpsClient;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class ASEAuthenticationHandler
implements CoreConstants {
    private IASEAuthenticationProvider m_authProvider;
    private List<String> cookies;

    public ASEAuthenticationHandler(IASEAuthenticationProvider provider) {
        this.m_authProvider = provider;
    }

    public boolean login(String username, String password, boolean persist, String url) throws IOException, JSONException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json; utf-8");
        headers.put("charset", "utf-8");
        headers.put("Accept", "application/json");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("keyId", username);
        params.put("keySecret", password);
        url = url + "/api/keylogin/apikeylogin";
        HttpsClient client = new HttpsClient();
        HttpResponse response = client.postForm(url, headers, params);
        this.cookies = response.getResponseHeaders().get("Set-Cookie");
        if (response.getResponseCode() == 200 || response.getResponseCode() == 201) {
            if (persist) {
                JSONObject object = (JSONObject)response.getResponseBodyAsJSON();
                String token = object.getString("sessionId");
                List<String> cookies = response.getResponseHeaders().get("Set-Cookie");
                this.m_authProvider.saveConnection(token);
                this.m_authProvider.setCookies(cookies);
            }
            return true;
        }
        String reason = response.getResponseBodyAsString() == null ? Messages.getMessage("message.unknown", new Object[0]) : response.getResponseBodyAsString();
        throw new HttpException(response.getResponseCode(), reason);
    }

    public List<String> getCookies() {
        return this.cookies;
    }

    public boolean isTokenExpired() {
        boolean isExpired;
        String request_url = this.m_authProvider.getServer() + "/api/currentuser_v2";
        Map<String, String> headers = this.m_authProvider.getAuthorizationHeader(false);
        headers.put("Accept", "application/json");
        headers.put("charset", "utf-8");
        headers.put("Accept", "application/json");
        HttpsClient httpClient = new HttpsClient();
        try {
            HttpResponse httpResponse = httpClient.get(request_url, headers, null);
            isExpired = httpResponse.getResponseCode() != 200;
        }
        catch (IOException e) {
            isExpired = true;
        }
        return isExpired;
    }
}

