/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.jenkins.plugin.scanners;

import com.hcl.appscan.jenkins.plugin.Messages;
import com.hcl.appscan.jenkins.plugin.auth.JenkinsAuthenticationProvider;
import com.hcl.appscan.jenkins.plugin.scanners.ScanDescriptor;
import com.hcl.appscan.jenkins.plugin.scanners.Scanner;
import com.hcl.appscan.sdk.auth.IAuthenticationProvider;
import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.scan.CloudScanServiceProvider;
import com.hcl.appscan.sdk.utils.ServiceUtil;
import hudson.AbortException;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.ItemGroup;
import hudson.util.FormValidation;
import hudson.util.VariableResolver;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class StaticAnalyzer
extends Scanner {
    private static final String STATIC_ANALYZER = "Static Analyzer";
    private boolean m_openSourceOnly;
    private String m_includeSCAGenerateIRX;
    private boolean m_hasOptionsUploadDirect;
    private String m_includeSCAUploadDirect;
    private boolean m_sourceCodeOnly;
    private String m_scanMethod;
    private String m_scanSpeed;

    @Deprecated
    public StaticAnalyzer(String target) {
        this(target, true);
    }

    public StaticAnalyzer(String target, boolean hasOptions, boolean rescan, String scanId, boolean openSourceOnly, boolean sourceCodeOnly, String scanMethod, String scanSpeed, String includeSCAGenerateIRX, boolean hasOptionsUploadDirect, String includeSCAUploadDirect) {
        super(target, hasOptions, rescan, scanId);
        this.m_openSourceOnly = openSourceOnly;
        this.m_sourceCodeOnly = sourceCodeOnly;
        this.m_scanMethod = scanMethod;
        this.m_scanSpeed = scanSpeed;
        this.m_includeSCAGenerateIRX = includeSCAGenerateIRX == null ? Boolean.toString(true) : includeSCAGenerateIRX;
        this.m_hasOptionsUploadDirect = hasOptionsUploadDirect;
        this.m_includeSCAUploadDirect = includeSCAUploadDirect;
    }

    @DataBoundConstructor
    public StaticAnalyzer(String target, boolean hasOptions) {
        super(target, hasOptions, false, "");
        this.m_openSourceOnly = false;
        this.m_sourceCodeOnly = false;
        this.m_scanMethod = "createIRX";
        this.m_scanSpeed = "";
        this.m_includeSCAGenerateIRX = Boolean.toString(true);
        this.m_hasOptionsUploadDirect = false;
        this.m_includeSCAUploadDirect = Boolean.toString(false);
    }

    @Override
    public String getType() {
        return STATIC_ANALYZER;
    }

    @DataBoundSetter
    public void setScanSpeed(String scanSpeed) {
        this.m_scanSpeed = scanSpeed;
    }

    public String getScanSpeed() {
        if (!this.m_scanMethod.equals("uploadDirect")) {
            return this.m_scanSpeed;
        }
        return "";
    }

    public String checkScanSpeed(String scanSpeed) {
        if (this.m_scanSpeed != null) {
            return this.m_scanSpeed.equalsIgnoreCase(scanSpeed) ? "true" : "false";
        }
        return null;
    }

    @DataBoundSetter
    public void setOpenSourceOnly(boolean openSourceOnly) {
        this.m_openSourceOnly = openSourceOnly;
    }

    public boolean getOpenSourceOnly() {
        return this.m_openSourceOnly;
    }

    @DataBoundSetter
    public void setIncludeSCAGenerateIRX(String includeSCAGenerateIRX) {
        this.m_includeSCAGenerateIRX = this.getHasOptions() && Boolean.parseBoolean(includeSCAGenerateIRX) ? Boolean.toString(true) : Boolean.toString(false);
    }

    public String getIncludeSCAGenerateIRX() {
        if (!this.m_scanMethod.equals("uploadDirect")) {
            return this.m_includeSCAGenerateIRX;
        }
        return "";
    }

    public String isIncludeSCAGenerateIRX(String includeSCAGenerateIRX) {
        if (this.m_includeSCAGenerateIRX != null) {
            return this.m_includeSCAGenerateIRX.equalsIgnoreCase(includeSCAGenerateIRX) ? Boolean.toString(true) : Boolean.toString(false);
        }
        return Boolean.toString(true);
    }

    @DataBoundSetter
    public void setHasOptionsUploadDirect(boolean hasOptionsUploadDirect) {
        this.m_hasOptionsUploadDirect = hasOptionsUploadDirect;
    }

    public boolean getHasOptionsUploadDirect() {
        return this.m_hasOptionsUploadDirect;
    }

    @DataBoundSetter
    public void setIncludeSCAUploadDirect(String includeSCAUploadDirect) {
        this.m_includeSCAUploadDirect = this.m_hasOptionsUploadDirect && Boolean.parseBoolean(includeSCAUploadDirect) ? Boolean.toString(true) : Boolean.toString(false);
    }

    public String getIncludeSCAUploadDirect() {
        if (this.m_scanMethod.equals("uploadDirect")) {
            return this.m_includeSCAUploadDirect;
        }
        return "";
    }

    public String isIncludeSCAUploadDirect(String includeSCAUploadDirect) {
        if (this.m_includeSCAUploadDirect != null) {
            return this.m_includeSCAUploadDirect.equalsIgnoreCase(includeSCAUploadDirect) ? Boolean.toString(true) : Boolean.toString(false);
        }
        return Boolean.toString(false);
    }

    @DataBoundSetter
    public void setSourceCodeOnly(boolean sourceCodeOnly) {
        this.m_sourceCodeOnly = sourceCodeOnly && this.getHasOptions();
    }

    public boolean isSourceCodeOnly() {
        if (!this.m_scanMethod.equals("uploadDirect")) {
            return this.m_sourceCodeOnly;
        }
        return false;
    }

    @DataBoundSetter
    public void setScanMethod(String scanMethod) {
        this.m_scanMethod = scanMethod;
    }

    public String getScanMethod() {
        return this.m_scanMethod;
    }

    public boolean isScanMethod(String scanMethod) {
        return this.m_scanMethod.equals(scanMethod);
    }

    @Override
    public void validateSettings(JenkinsAuthenticationProvider authProvider, Map<String, String> properties, IProgress progress, boolean isAppScan360) throws IOException {
        super.validateSettings(authProvider, properties, progress, isAppScan360);
        if (!ServiceUtil.hasSastEntitlement((IAuthenticationProvider)authProvider)) {
            throw new AbortException(Messages.error_active_subscription_validation(this.getType()));
        }
        if (this.getRescan() && !properties.containsKey("ScanId")) {
            throw new AbortException(Messages.error_empty_scan_id());
        }
        if (properties.containsKey("ScanId")) {
            properties.remove("includeSCA");
        }
        if (properties.containsKey("includeSCA") && !ServiceUtil.hasScaEntitlement((IAuthenticationProvider)authProvider)) {
            progress.setStatus(new Message(1, Messages.warning_sca_subscription()));
            properties.remove("includeSCA");
        }
        if (properties.containsKey("includeSCA") && properties.containsKey("uploadDirect") && !properties.get("target").endsWith(".irx")) {
            throw new AbortException(Messages.error_invalid_format_include_sca());
        }
        if (properties.containsKey("ScanId")) {
            try {
                JSONObject scanDetails = new CloudScanServiceProvider((IAuthenticationProvider)authProvider).getScanDetails(STATIC_ANALYZER, properties.get("ScanId"));
                if (scanDetails != null && scanDetails.containsKey((Object)"GitRepoPlatform") && scanDetails.get("GitRepoPlatform") != null) {
                    throw new AbortException(Messages.error_invalid_scan_id_git_repo());
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    @Override
    public Map<String, String> getProperties(VariableResolver<String> resolver) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("target", resolver == null ? this.getTarget() : this.resolvePath(this.getTarget(), resolver));
        if (this.m_scanMethod != null && this.m_scanMethod.equals("uploadDirect")) {
            properties.put("uploadDirect", "");
        }
        if (this.m_openSourceOnly && this.getHasOptions()) {
            properties.put("openSourceOnly", "");
        }
        if (this.m_sourceCodeOnly && !this.m_scanMethod.equals("uploadDirect")) {
            properties.put("sourceCodeOnly", "");
        }
        if (this.m_scanMethod.equals("createIRX") && (this.m_includeSCAGenerateIRX == null || Boolean.parseBoolean(this.m_includeSCAGenerateIRX)) || this.m_scanMethod.equals("uploadDirect") && Boolean.parseBoolean(this.m_includeSCAUploadDirect)) {
            properties.put("includeSCA", "");
        }
        if (this.isNullOrEmpty(this.m_scanSpeed) && this.getHasOptions()) {
            properties.put("scanSpeed", this.m_scanSpeed);
        }
        if (this.getRescan() && this.isNullOrEmpty(this.getScanId())) {
            properties.put("ScanId", this.getScanId());
        }
        return properties;
    }

    @Symbol(value={"static_analyzer"})
    @Extension
    public static final class DescriptorImpl
    extends ScanDescriptor {
        public String getDisplayName() {
            return "Static Analysis (SAST)";
        }

        public FormValidation doCheckScanId(@QueryParameter String scanId, @RelativePath(value="..") @QueryParameter String application, @RelativePath(value="..") @QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            if (scanId == null || scanId.isEmpty()) {
                return FormValidation.validateRequired((String)scanId);
            }
            JenkinsAuthenticationProvider provider = new JenkinsAuthenticationProvider(credentials, context);
            JSONObject scanDetails = new CloudScanServiceProvider((IAuthenticationProvider)provider).getScanDetails(StaticAnalyzer.STATIC_ANALYZER, scanId);
            if (this.isGitRepoPlatform(scanDetails)) {
                return FormValidation.error((String)Messages.error_invalid_scan_id_git_repo_ui());
            }
            try {
                return this.scanIdValidation(scanDetails, application);
            }
            catch (JSONException jSONException) {
                return FormValidation.ok();
            }
        }

        private boolean isGitRepoPlatform(JSONObject scanDetails) {
            try {
                return scanDetails != null && scanDetails.containsKey((Object)"GitRepoPlatform") && scanDetails.get("GitRepoPlatform") != null;
            }
            catch (JSONException jSONException) {
                return false;
            }
        }

        public FormValidation doCheckTarget(@RelativePath(value="..") @QueryParameter String credentials, @AncestorInPath ItemGroup<?> context) {
            JenkinsAuthenticationProvider authProvider = new JenkinsAuthenticationProvider(credentials, context);
            if (!ServiceUtil.hasSastEntitlement((IAuthenticationProvider)authProvider)) {
                return FormValidation.error((String)Messages.error_active_subscription_validation_ui());
            }
            return FormValidation.ok();
        }
    }
}

